// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class PutAccountSettingRequest private constructor(builder: Builder) {
    /**
     * The Amazon ECS resource name for which to modify the account setting. If you specify `serviceLongArnFormat`, the ARN for your Amazon ECS services is affected. If you specify `taskLongArnFormat`, the ARN and resource ID for your Amazon ECS tasks is affected. If you specify `containerInstanceLongArnFormat`, the ARN and resource ID for your Amazon ECS container instances is affected. If you specify `awsvpcTrunking`, the elastic network interface (ENI) limit for your Amazon ECS container instances is affected. If you specify `containerInsights`, the default setting for Amazon Web Services CloudWatch Container Insights for your clusters is affected. If you specify `fargateFIPSMode`, Fargate FIPS 140 compliance is affected. If you specify `tagResourceAuthorization`, the opt-in option for tagging resources on creation is affected. For information about the opt-in timeline, see [Tagging authorization timeline](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#tag-resources) in the *Amazon ECS Developer Guide*. If you specify `fargateTaskRetirementWaitPeriod`, the wait time to retire a Fargate task is affected.
     *
     * The `guardDutyActivate` parameter is read-only in Amazon ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see [Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html).
     */
    public val name: aws.sdk.kotlin.services.ecs.model.SettingName? = builder.name
    /**
     * The ARN of the principal, which can be a user, role, or the root user. If you specify the root user, it modifies the account setting for all users, roles, and the root user of the account unless a user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.
     *
     * You must use the root user when you set the Fargate wait time (`fargateTaskRetirementWaitPeriod`).
     *
     * Federated users assume the account setting of the root user and can't have explicit account settings set for them.
     */
    public val principalArn: kotlin.String? = builder.principalArn
    /**
     * The account setting value for the specified principal ARN. Accepted values are `enabled`, `disabled`, `on`, and `off`.
     *
     * When you specify `fargateTaskRetirementWaitPeriod` for the `name`, the following are the valid values:
     * + `0` - Amazon Web Services sends the notification, and immediately retires the affected tasks.
     * + `7` - Amazon Web Services sends the notification, and waits 7 calendar days to retire the tasks.
     * + `14` - Amazon Web Services sends the notification, and waits 14 calendar days to retire the tasks.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.PutAccountSettingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAccountSettingRequest(")
        append("name=$name,")
        append("principalArn=$principalArn,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAccountSettingRequest

        if (name != other.name) return false
        if (principalArn != other.principalArn) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.PutAccountSettingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon ECS resource name for which to modify the account setting. If you specify `serviceLongArnFormat`, the ARN for your Amazon ECS services is affected. If you specify `taskLongArnFormat`, the ARN and resource ID for your Amazon ECS tasks is affected. If you specify `containerInstanceLongArnFormat`, the ARN and resource ID for your Amazon ECS container instances is affected. If you specify `awsvpcTrunking`, the elastic network interface (ENI) limit for your Amazon ECS container instances is affected. If you specify `containerInsights`, the default setting for Amazon Web Services CloudWatch Container Insights for your clusters is affected. If you specify `fargateFIPSMode`, Fargate FIPS 140 compliance is affected. If you specify `tagResourceAuthorization`, the opt-in option for tagging resources on creation is affected. For information about the opt-in timeline, see [Tagging authorization timeline](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#tag-resources) in the *Amazon ECS Developer Guide*. If you specify `fargateTaskRetirementWaitPeriod`, the wait time to retire a Fargate task is affected.
         *
         * The `guardDutyActivate` parameter is read-only in Amazon ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see [Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html).
         */
        public var name: aws.sdk.kotlin.services.ecs.model.SettingName? = null
        /**
         * The ARN of the principal, which can be a user, role, or the root user. If you specify the root user, it modifies the account setting for all users, roles, and the root user of the account unless a user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.
         *
         * You must use the root user when you set the Fargate wait time (`fargateTaskRetirementWaitPeriod`).
         *
         * Federated users assume the account setting of the root user and can't have explicit account settings set for them.
         */
        public var principalArn: kotlin.String? = null
        /**
         * The account setting value for the specified principal ARN. Accepted values are `enabled`, `disabled`, `on`, and `off`.
         *
         * When you specify `fargateTaskRetirementWaitPeriod` for the `name`, the following are the valid values:
         * + `0` - Amazon Web Services sends the notification, and immediately retires the affected tasks.
         * + `7` - Amazon Web Services sends the notification, and waits 7 calendar days to retire the tasks.
         * + `14` - Amazon Web Services sends the notification, and waits 14 calendar days to retire the tasks.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.PutAccountSettingRequest) : this() {
            this.name = x.name
            this.principalArn = x.principalArn
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.PutAccountSettingRequest = PutAccountSettingRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
