// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * Details on an Elastic Inference accelerator. For more information, see [Working with Amazon Elastic Inference on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class InferenceAccelerator private constructor(builder: Builder) {
    /**
     * The Elastic Inference accelerator device name. The `deviceName` must also be referenced in a container definition as a [ResourceRequirement](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html).
     */
    public val deviceName: kotlin.String = requireNotNull(builder.deviceName) { "A non-null value must be provided for deviceName" }
    /**
     * The Elastic Inference accelerator type to use.
     */
    public val deviceType: kotlin.String = requireNotNull(builder.deviceType) { "A non-null value must be provided for deviceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.InferenceAccelerator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceAccelerator(")
        append("deviceName=$deviceName,")
        append("deviceType=$deviceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName.hashCode()
        result = 31 * result + (deviceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceAccelerator

        if (deviceName != other.deviceName) return false
        if (deviceType != other.deviceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.InferenceAccelerator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Elastic Inference accelerator device name. The `deviceName` must also be referenced in a container definition as a [ResourceRequirement](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html).
         */
        public var deviceName: kotlin.String? = null
        /**
         * The Elastic Inference accelerator type to use.
         */
        public var deviceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.InferenceAccelerator) : this() {
            this.deviceName = x.deviceName
            this.deviceType = x.deviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.InferenceAccelerator = InferenceAccelerator(this)

        internal fun correctErrors(): Builder {
            if (deviceName == null) deviceName = ""
            if (deviceType == null) deviceType = ""
            return this
        }
    }
}
