// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * An object representing a container health check. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image (such as those specified in a parent image or from the image's Dockerfile). This configuration maps to the `HEALTHCHECK` parameter of [docker run](https://docs.docker.com/engine/reference/run/).
 *
 * The Amazon ECS container agent only monitors and reports on the health checks specified in the task definition. Amazon ECS does not monitor Docker health checks that are embedded in a container image and not specified in the container definition. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image.
 *
 * You can view the health status of both individual containers and a task with the DescribeTasks API operation or when viewing the task details in the console.
 *
 * The health check is designed to make sure that your containers survive agent restarts, upgrades, or temporary unavailability.
 *
 * The following describes the possible `healthStatus` values for a container:
 * + `HEALTHY`-The container health check has passed successfully.
 * + `UNHEALTHY`-The container health check has failed.
 * + `UNKNOWN`-The container health check is being evaluated, there's no container health check defined, or Amazon ECS doesn't have the health status of the container.
 *
 * The following describes the possible `healthStatus` values based on the container health checker status of essential containers in the task with the following priority order (high to low):
 * + `UNHEALTHY`-One or more essential containers have failed their health check.
 * + `UNKNOWN`-Any essential container running within the task is in an `UNKNOWN` state and no other essential containers have an `UNHEALTHY` state.
 * + `HEALTHY`-All essential containers within the task have passed their health checks.
 *
 * Consider the following task health example with 2 containers.
 * + If Container1 is `UNHEALTHY` and Container2 is `UNKNOWN`, the task health is `UNHEALTHY`.
 * + If Container1 is `UNHEALTHY` and Container2 is `HEALTHY`, the task health is `UNHEALTHY`.
 * + If Container1 is `HEALTHY` and Container2 is `UNKNOWN`, the task health is `UNKNOWN`.
 * + If Container1 is `HEALTHY` and Container2 is `HEALTHY`, the task health is `HEALTHY`.
 *
 * Consider the following task health example with 3 containers.
 * + If Container1 is `UNHEALTHY` and Container2 is `UNKNOWN`, and Container3 is `UNKNOWN`, the task health is `UNHEALTHY`.
 * + If Container1 is `UNHEALTHY` and Container2 is `UNKNOWN`, and Container3 is `HEALTHY`, the task health is `UNHEALTHY`.
 * + If Container1 is `UNHEALTHY` and Container2 is `HEALTHY`, and Container3 is `HEALTHY`, the task health is `UNHEALTHY`.
 * + If Container1 is `HEALTHY` and Container2 is `UNKNOWN`, and Container3 is `HEALTHY`, the task health is `UNKNOWN`.
 * + If Container1 is `HEALTHY` and Container2 is `UNKNOWN`, and Container3 is `UNKNOWN`, the task health is `UNKNOWN`.
 * + If Container1 is `HEALTHY` and Container2 is `HEALTHY`, and Container3 is `HEALTHY`, the task health is `HEALTHY`.
 *
 * If a task is run manually, and not as part of a service, the task will continue its lifecycle regardless of its health status. For tasks that are part of a service, if the task reports as unhealthy then the task will be stopped and the service scheduler will replace it.
 *
 * The following are notes about container health check support:
 * + When the Amazon ECS agent cannot connect to the Amazon ECS service, the service reports the container as `UNHEALTHY`.
 * + The health check statuses are the "last heard from" response from the Amazon ECS agent. There are no assumptions made about the status of the container health checks.
 * + Container health checks require version 1.17.0 or greater of the Amazon ECS container agent. For more information, see [Updating the Amazon ECS container agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html).
 * + Container health checks are supported for Fargate tasks if you're using platform version `1.1.0` or greater. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
 * + Container health checks aren't supported for tasks that are part of a service that's configured to use a Classic Load Balancer.
 */
public class HealthCheck private constructor(builder: Builder) {
    /**
     * A string array representing the command that the container runs to determine if it is healthy. The string array must start with `CMD` to run the command arguments directly, or `CMD-SHELL` to run the command with the container's default shell.
     *
     *  When you use the Amazon Web Services Management Console JSON panel, the Command Line Interface, or the APIs, enclose the list of commands in double quotes and brackets.
     *
     * `[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]`
     *
     * You don't include the double quotes and brackets when you use the Amazon Web Services Management Console.
     *
     * ` CMD-SHELL, curl -f http://localhost/ || exit 1`
     *
     * An exit code of 0 indicates success, and non-zero exit code indicates failure. For more information, see `HealthCheck` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/).
     */
    public val command: List<String> = requireNotNull(builder.command) { "A non-null value must be provided for command" }
    /**
     * The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is 3.
     */
    public val retries: kotlin.Int? = builder.retries
    /**
     * The optional grace period to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You can specify between 0 and 300 seconds. By default, the `startPeriod` is off.
     *
     * If a health check succeeds within the `startPeriod`, then the container is considered healthy and any subsequent failures count toward the maximum number of retries.
     */
    public val startPeriod: kotlin.Int? = builder.startPeriod
    /**
     * The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5.
     */
    public val timeout: kotlin.Int? = builder.timeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.HealthCheck = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheck(")
        append("command=$command,")
        append("interval=$interval,")
        append("retries=$retries,")
        append("startPeriod=$startPeriod,")
        append("timeout=$timeout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = command.hashCode()
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (retries ?: 0)
        result = 31 * result + (startPeriod ?: 0)
        result = 31 * result + (timeout ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheck

        if (command != other.command) return false
        if (interval != other.interval) return false
        if (retries != other.retries) return false
        if (startPeriod != other.startPeriod) return false
        if (timeout != other.timeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.HealthCheck = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string array representing the command that the container runs to determine if it is healthy. The string array must start with `CMD` to run the command arguments directly, or `CMD-SHELL` to run the command with the container's default shell.
         *
         *  When you use the Amazon Web Services Management Console JSON panel, the Command Line Interface, or the APIs, enclose the list of commands in double quotes and brackets.
         *
         * `[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]`
         *
         * You don't include the double quotes and brackets when you use the Amazon Web Services Management Console.
         *
         * ` CMD-SHELL, curl -f http://localhost/ || exit 1`
         *
         * An exit code of 0 indicates success, and non-zero exit code indicates failure. For more information, see `HealthCheck` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/).
         */
        public var command: List<String>? = null
        /**
         * The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds.
         */
        public var interval: kotlin.Int? = null
        /**
         * The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is 3.
         */
        public var retries: kotlin.Int? = null
        /**
         * The optional grace period to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You can specify between 0 and 300 seconds. By default, the `startPeriod` is off.
         *
         * If a health check succeeds within the `startPeriod`, then the container is considered healthy and any subsequent failures count toward the maximum number of retries.
         */
        public var startPeriod: kotlin.Int? = null
        /**
         * The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5.
         */
        public var timeout: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.HealthCheck) : this() {
            this.command = x.command
            this.interval = x.interval
            this.retries = x.retries
            this.startPeriod = x.startPeriod
            this.timeout = x.timeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.HealthCheck = HealthCheck(this)

        internal fun correctErrors(): Builder {
            if (command == null) command = emptyList()
            return this
        }
    }
}
