// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class FirelensConfiguration private constructor(builder: Builder) {
    /**
     * The options to use when configuring the log router. This field is optional and can be used to specify a custom configuration file or to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event. If specified, the syntax to use is `"options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}`. For more information, see [Creating a task definition that uses a FireLens configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Tasks hosted on Fargate only support the `file` configuration file type.
     */
    public val options: Map<String, String>? = builder.options
    /**
     * The log router to use. The valid values are `fluentd` or `fluentbit`.
     */
    public val type: aws.sdk.kotlin.services.ecs.model.FirelensConfigurationType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.FirelensConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirelensConfiguration(")
        append("options=$options,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = options?.hashCode() ?: 0
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirelensConfiguration

        if (options != other.options) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.FirelensConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The options to use when configuring the log router. This field is optional and can be used to specify a custom configuration file or to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event. If specified, the syntax to use is `"options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}`. For more information, see [Creating a task definition that uses a FireLens configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * Tasks hosted on Fargate only support the `file` configuration file type.
         */
        public var options: Map<String, String>? = null
        /**
         * The log router to use. The valid values are `fluentd` or `fluentbit`.
         */
        public var type: aws.sdk.kotlin.services.ecs.model.FirelensConfigurationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.FirelensConfiguration) : this() {
            this.options = x.options
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.FirelensConfiguration = FirelensConfiguration(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = FirelensConfigurationType.SdkUnknown("no value provided")
            return this
        }
    }
}
