// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * This parameter is specified when you're using [Amazon FSx for Windows File Server](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) file system for task storage.
 *
 * For more information and the input format, see [Amazon FSx for Windows File Server volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class FSxWindowsFileServerVolumeConfiguration private constructor(builder: Builder) {
    /**
     * The authorization configuration details for the Amazon FSx for Windows File Server file system.
     */
    public val authorizationConfig: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig? = builder.authorizationConfig
    /**
     * The Amazon FSx for Windows File Server file system ID to use.
     */
    public val fileSystemId: kotlin.String = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
     */
    public val rootDirectory: kotlin.String = requireNotNull(builder.rootDirectory) { "A non-null value must be provided for rootDirectory" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FSxWindowsFileServerVolumeConfiguration(")
        append("authorizationConfig=$authorizationConfig,")
        append("fileSystemId=$fileSystemId,")
        append("rootDirectory=$rootDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationConfig?.hashCode() ?: 0
        result = 31 * result + (fileSystemId.hashCode())
        result = 31 * result + (rootDirectory.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FSxWindowsFileServerVolumeConfiguration

        if (authorizationConfig != other.authorizationConfig) return false
        if (fileSystemId != other.fileSystemId) return false
        if (rootDirectory != other.rootDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authorization configuration details for the Amazon FSx for Windows File Server file system.
         */
        public var authorizationConfig: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig? = null
        /**
         * The Amazon FSx for Windows File Server file system ID to use.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
         */
        public var rootDirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration) : this() {
            this.authorizationConfig = x.authorizationConfig
            this.fileSystemId = x.fileSystemId
            this.rootDirectory = x.rootDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerVolumeConfiguration = FSxWindowsFileServerVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig] inside the given [block]
         */
        public fun authorizationConfig(block: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig.Builder.() -> kotlin.Unit) {
            this.authorizationConfig = aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (fileSystemId == null) fileSystemId = ""
            if (rootDirectory == null) rootDirectory = ""
            return this
        }
    }
}
