// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The authorization configuration details for the Amazon EFS file system.
 */
public class EfsAuthorizationConfig private constructor(builder: Builder) {
    /**
     * The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be on in the `EFSVolumeConfiguration`. For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide*.
     */
    public val accessPointId: kotlin.String? = builder.accessPointId
    /**
     * Determines whether to use the Amazon ECS task role defined in a task definition when mounting the Amazon EFS file system. If it is turned on, transit encryption must be turned on in the `EFSVolumeConfiguration`. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val iam: aws.sdk.kotlin.services.ecs.model.EfsAuthorizationConfigIam? = builder.iam

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.EfsAuthorizationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EfsAuthorizationConfig(")
        append("accessPointId=$accessPointId,")
        append("iam=$iam")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointId?.hashCode() ?: 0
        result = 31 * result + (iam?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EfsAuthorizationConfig

        if (accessPointId != other.accessPointId) return false
        if (iam != other.iam) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.EfsAuthorizationConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the `EFSVolumeConfiguration` must either be omitted or set to `/` which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be on in the `EFSVolumeConfiguration`. For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide*.
         */
        public var accessPointId: kotlin.String? = null
        /**
         * Determines whether to use the Amazon ECS task role defined in a task definition when mounting the Amazon EFS file system. If it is turned on, transit encryption must be turned on in the `EFSVolumeConfiguration`. If this parameter is omitted, the default value of `DISABLED` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var iam: aws.sdk.kotlin.services.ecs.model.EfsAuthorizationConfigIam? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.EfsAuthorizationConfig) : this() {
            this.accessPointId = x.accessPointId
            this.iam = x.iam
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.EfsAuthorizationConfig = EfsAuthorizationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
