// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The deployment controller to use for the service. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class DeploymentController private constructor(builder: Builder) {
    /**
     * The deployment controller type to use.
     *
     * There are three deployment controller types available:
     *
     * ## ECS
     * The rolling update (`ECS`) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the DeploymentConfiguration.
     *
     * ## CODE_DEPLOY
     * The blue/green (`CODE_DEPLOY`) deployment type uses the blue/green deployment model powered by CodeDeploy, which allows you to verify a new deployment of a service before sending production traffic to it.
     *
     * ## EXTERNAL
     * The external (`EXTERNAL`) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.
     */
    public val type: aws.sdk.kotlin.services.ecs.model.DeploymentControllerType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.DeploymentController = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentController(")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentController

        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.DeploymentController = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The deployment controller type to use.
         *
         * There are three deployment controller types available:
         *
         * ## ECS
         * The rolling update (`ECS`) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the DeploymentConfiguration.
         *
         * ## CODE_DEPLOY
         * The blue/green (`CODE_DEPLOY`) deployment type uses the blue/green deployment model powered by CodeDeploy, which allows you to verify a new deployment of a service before sending production traffic to it.
         *
         * ## EXTERNAL
         * The external (`EXTERNAL`) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.
         */
        public var type: aws.sdk.kotlin.services.ecs.model.DeploymentControllerType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.DeploymentController) : this() {
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.DeploymentController = DeploymentController(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = DeploymentControllerType.SdkUnknown("no value provided")
            return this
        }
    }
}
