// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The `RunTask` request could not be processed due to conflicts. The provided `clientToken` is already in use with a different `RunTask` request. The `resourceIds` are the existing task ARNs which are already associated with the `clientToken`.
 *
 * To fix this issue:
 * + Run `RunTask` with a unique `clientToken`.
 * + Run `RunTask` with the `clientToken` and the original set of parameters
 */
public class ConflictException private constructor(builder: Builder) : EcsException() {

    /**
     * Message that describes the cause of the exception.
     */
    override val message: kotlin.String? = builder.message
    /**
     * The existing task ARNs which are already associated with the `clientToken`.
     */
    public val resourceIds: List<String>? = builder.resourceIds

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ConflictException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictException(")
        append("message=$message,")
        append("resourceIds=$resourceIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConflictException

        if (message != other.message) return false
        if (resourceIds != other.resourceIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ConflictException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Message that describes the cause of the exception.
         */
        public var message: kotlin.String? = null
        /**
         * The existing task ARNs which are already associated with the `clientToken`.
         */
        public var resourceIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ConflictException) : this() {
            this.message = x.message
            this.resourceIds = x.resourceIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ConflictException = ConflictException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
