// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The details of the Auto Scaling group for the capacity provider.
 */
public class AutoScalingGroupProvider private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that identifies the Auto Scaling group, or the Auto Scaling group name.
     */
    public val autoScalingGroupArn: kotlin.String = requireNotNull(builder.autoScalingGroupArn) { "A non-null value must be provided for autoScalingGroupArn" }
    /**
     * The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
     */
    public val managedDraining: aws.sdk.kotlin.services.ecs.model.ManagedDraining? = builder.managedDraining
    /**
     * The managed scaling settings for the Auto Scaling group capacity provider.
     */
    public val managedScaling: aws.sdk.kotlin.services.ecs.model.ManagedScaling? = builder.managedScaling
    /**
     * The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines whether the Auto Scaling group has managed termination protection. The default is off.
     *
     * When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
     *
     * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on as well. For more information, see [Instance Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection) in the *Auto Scaling User Guide*.
     *
     * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
     */
    public val managedTerminationProtection: aws.sdk.kotlin.services.ecs.model.ManagedTerminationProtection? = builder.managedTerminationProtection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupProvider(")
        append("autoScalingGroupArn=$autoScalingGroupArn,")
        append("managedDraining=$managedDraining,")
        append("managedScaling=$managedScaling,")
        append("managedTerminationProtection=$managedTerminationProtection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupArn.hashCode()
        result = 31 * result + (managedDraining?.hashCode() ?: 0)
        result = 31 * result + (managedScaling?.hashCode() ?: 0)
        result = 31 * result + (managedTerminationProtection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroupProvider

        if (autoScalingGroupArn != other.autoScalingGroupArn) return false
        if (managedDraining != other.managedDraining) return false
        if (managedScaling != other.managedScaling) return false
        if (managedTerminationProtection != other.managedTerminationProtection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that identifies the Auto Scaling group, or the Auto Scaling group name.
         */
        public var autoScalingGroupArn: kotlin.String? = null
        /**
         * The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
         */
        public var managedDraining: aws.sdk.kotlin.services.ecs.model.ManagedDraining? = null
        /**
         * The managed scaling settings for the Auto Scaling group capacity provider.
         */
        public var managedScaling: aws.sdk.kotlin.services.ecs.model.ManagedScaling? = null
        /**
         * The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines whether the Auto Scaling group has managed termination protection. The default is off.
         *
         * When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
         *
         * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on as well. For more information, see [Instance Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection) in the *Auto Scaling User Guide*.
         *
         * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
         */
        public var managedTerminationProtection: aws.sdk.kotlin.services.ecs.model.ManagedTerminationProtection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider) : this() {
            this.autoScalingGroupArn = x.autoScalingGroupArn
            this.managedDraining = x.managedDraining
            this.managedScaling = x.managedScaling
            this.managedTerminationProtection = x.managedTerminationProtection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider = AutoScalingGroupProvider(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ManagedScaling] inside the given [block]
         */
        public fun managedScaling(block: aws.sdk.kotlin.services.ecs.model.ManagedScaling.Builder.() -> kotlin.Unit) {
            this.managedScaling = aws.sdk.kotlin.services.ecs.model.ManagedScaling.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (autoScalingGroupArn == null) autoScalingGroupArn = ""
            return this
        }
    }
}
