// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.ecs.auth.DefaultEcsAuthSchemeProvider
import aws.sdk.kotlin.services.ecs.auth.EcsAuthSchemeProvider
import aws.sdk.kotlin.services.ecs.endpoints.DefaultEcsEndpointProvider
import aws.sdk.kotlin.services.ecs.endpoints.EcsEndpointParameters
import aws.sdk.kotlin.services.ecs.endpoints.EcsEndpointProvider
import aws.sdk.kotlin.services.ecs.model.CreateCapacityProviderRequest
import aws.sdk.kotlin.services.ecs.model.CreateCapacityProviderResponse
import aws.sdk.kotlin.services.ecs.model.CreateClusterRequest
import aws.sdk.kotlin.services.ecs.model.CreateClusterResponse
import aws.sdk.kotlin.services.ecs.model.CreateServiceRequest
import aws.sdk.kotlin.services.ecs.model.CreateServiceResponse
import aws.sdk.kotlin.services.ecs.model.CreateTaskSetRequest
import aws.sdk.kotlin.services.ecs.model.CreateTaskSetResponse
import aws.sdk.kotlin.services.ecs.model.DeleteAccountSettingRequest
import aws.sdk.kotlin.services.ecs.model.DeleteAccountSettingResponse
import aws.sdk.kotlin.services.ecs.model.DeleteAttributesRequest
import aws.sdk.kotlin.services.ecs.model.DeleteAttributesResponse
import aws.sdk.kotlin.services.ecs.model.DeleteCapacityProviderRequest
import aws.sdk.kotlin.services.ecs.model.DeleteCapacityProviderResponse
import aws.sdk.kotlin.services.ecs.model.DeleteClusterRequest
import aws.sdk.kotlin.services.ecs.model.DeleteClusterResponse
import aws.sdk.kotlin.services.ecs.model.DeleteServiceRequest
import aws.sdk.kotlin.services.ecs.model.DeleteServiceResponse
import aws.sdk.kotlin.services.ecs.model.DeleteTaskDefinitionsRequest
import aws.sdk.kotlin.services.ecs.model.DeleteTaskDefinitionsResponse
import aws.sdk.kotlin.services.ecs.model.DeleteTaskSetRequest
import aws.sdk.kotlin.services.ecs.model.DeleteTaskSetResponse
import aws.sdk.kotlin.services.ecs.model.DeregisterContainerInstanceRequest
import aws.sdk.kotlin.services.ecs.model.DeregisterContainerInstanceResponse
import aws.sdk.kotlin.services.ecs.model.DeregisterTaskDefinitionRequest
import aws.sdk.kotlin.services.ecs.model.DeregisterTaskDefinitionResponse
import aws.sdk.kotlin.services.ecs.model.DescribeCapacityProvidersRequest
import aws.sdk.kotlin.services.ecs.model.DescribeCapacityProvidersResponse
import aws.sdk.kotlin.services.ecs.model.DescribeClustersRequest
import aws.sdk.kotlin.services.ecs.model.DescribeClustersResponse
import aws.sdk.kotlin.services.ecs.model.DescribeContainerInstancesRequest
import aws.sdk.kotlin.services.ecs.model.DescribeContainerInstancesResponse
import aws.sdk.kotlin.services.ecs.model.DescribeServicesRequest
import aws.sdk.kotlin.services.ecs.model.DescribeServicesResponse
import aws.sdk.kotlin.services.ecs.model.DescribeTaskDefinitionRequest
import aws.sdk.kotlin.services.ecs.model.DescribeTaskDefinitionResponse
import aws.sdk.kotlin.services.ecs.model.DescribeTaskSetsRequest
import aws.sdk.kotlin.services.ecs.model.DescribeTaskSetsResponse
import aws.sdk.kotlin.services.ecs.model.DescribeTasksRequest
import aws.sdk.kotlin.services.ecs.model.DescribeTasksResponse
import aws.sdk.kotlin.services.ecs.model.DiscoverPollEndpointRequest
import aws.sdk.kotlin.services.ecs.model.DiscoverPollEndpointResponse
import aws.sdk.kotlin.services.ecs.model.ExecuteCommandRequest
import aws.sdk.kotlin.services.ecs.model.ExecuteCommandResponse
import aws.sdk.kotlin.services.ecs.model.GetTaskProtectionRequest
import aws.sdk.kotlin.services.ecs.model.GetTaskProtectionResponse
import aws.sdk.kotlin.services.ecs.model.ListAccountSettingsRequest
import aws.sdk.kotlin.services.ecs.model.ListAccountSettingsResponse
import aws.sdk.kotlin.services.ecs.model.ListAttributesRequest
import aws.sdk.kotlin.services.ecs.model.ListAttributesResponse
import aws.sdk.kotlin.services.ecs.model.ListClustersRequest
import aws.sdk.kotlin.services.ecs.model.ListClustersResponse
import aws.sdk.kotlin.services.ecs.model.ListContainerInstancesRequest
import aws.sdk.kotlin.services.ecs.model.ListContainerInstancesResponse
import aws.sdk.kotlin.services.ecs.model.ListServicesByNamespaceRequest
import aws.sdk.kotlin.services.ecs.model.ListServicesByNamespaceResponse
import aws.sdk.kotlin.services.ecs.model.ListServicesRequest
import aws.sdk.kotlin.services.ecs.model.ListServicesResponse
import aws.sdk.kotlin.services.ecs.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ecs.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionFamiliesRequest
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionFamiliesResponse
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionsRequest
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionsResponse
import aws.sdk.kotlin.services.ecs.model.ListTasksRequest
import aws.sdk.kotlin.services.ecs.model.ListTasksResponse
import aws.sdk.kotlin.services.ecs.model.PutAccountSettingDefaultRequest
import aws.sdk.kotlin.services.ecs.model.PutAccountSettingDefaultResponse
import aws.sdk.kotlin.services.ecs.model.PutAccountSettingRequest
import aws.sdk.kotlin.services.ecs.model.PutAccountSettingResponse
import aws.sdk.kotlin.services.ecs.model.PutAttributesRequest
import aws.sdk.kotlin.services.ecs.model.PutAttributesResponse
import aws.sdk.kotlin.services.ecs.model.PutClusterCapacityProvidersRequest
import aws.sdk.kotlin.services.ecs.model.PutClusterCapacityProvidersResponse
import aws.sdk.kotlin.services.ecs.model.RegisterContainerInstanceRequest
import aws.sdk.kotlin.services.ecs.model.RegisterContainerInstanceResponse
import aws.sdk.kotlin.services.ecs.model.RegisterTaskDefinitionRequest
import aws.sdk.kotlin.services.ecs.model.RegisterTaskDefinitionResponse
import aws.sdk.kotlin.services.ecs.model.RunTaskRequest
import aws.sdk.kotlin.services.ecs.model.RunTaskResponse
import aws.sdk.kotlin.services.ecs.model.StartTaskRequest
import aws.sdk.kotlin.services.ecs.model.StartTaskResponse
import aws.sdk.kotlin.services.ecs.model.StopTaskRequest
import aws.sdk.kotlin.services.ecs.model.StopTaskResponse
import aws.sdk.kotlin.services.ecs.model.SubmitAttachmentStateChangesRequest
import aws.sdk.kotlin.services.ecs.model.SubmitAttachmentStateChangesResponse
import aws.sdk.kotlin.services.ecs.model.SubmitContainerStateChangeRequest
import aws.sdk.kotlin.services.ecs.model.SubmitContainerStateChangeResponse
import aws.sdk.kotlin.services.ecs.model.SubmitTaskStateChangeRequest
import aws.sdk.kotlin.services.ecs.model.SubmitTaskStateChangeResponse
import aws.sdk.kotlin.services.ecs.model.TagResourceRequest
import aws.sdk.kotlin.services.ecs.model.TagResourceResponse
import aws.sdk.kotlin.services.ecs.model.UntagResourceRequest
import aws.sdk.kotlin.services.ecs.model.UntagResourceResponse
import aws.sdk.kotlin.services.ecs.model.UpdateCapacityProviderRequest
import aws.sdk.kotlin.services.ecs.model.UpdateCapacityProviderResponse
import aws.sdk.kotlin.services.ecs.model.UpdateClusterRequest
import aws.sdk.kotlin.services.ecs.model.UpdateClusterResponse
import aws.sdk.kotlin.services.ecs.model.UpdateClusterSettingsRequest
import aws.sdk.kotlin.services.ecs.model.UpdateClusterSettingsResponse
import aws.sdk.kotlin.services.ecs.model.UpdateContainerAgentRequest
import aws.sdk.kotlin.services.ecs.model.UpdateContainerAgentResponse
import aws.sdk.kotlin.services.ecs.model.UpdateContainerInstancesStateRequest
import aws.sdk.kotlin.services.ecs.model.UpdateContainerInstancesStateResponse
import aws.sdk.kotlin.services.ecs.model.UpdateServicePrimaryTaskSetRequest
import aws.sdk.kotlin.services.ecs.model.UpdateServicePrimaryTaskSetResponse
import aws.sdk.kotlin.services.ecs.model.UpdateServiceRequest
import aws.sdk.kotlin.services.ecs.model.UpdateServiceResponse
import aws.sdk.kotlin.services.ecs.model.UpdateTaskProtectionRequest
import aws.sdk.kotlin.services.ecs.model.UpdateTaskProtectionResponse
import aws.sdk.kotlin.services.ecs.model.UpdateTaskSetRequest
import aws.sdk.kotlin.services.ecs.model.UpdateTaskSetResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ECS"
public const val SdkVersion: String = "1.0.46"
public const val ServiceApiVersion: String = "2014-11-13"

/**
 * # Amazon Elastic Container Service
 * Amazon Elastic Container Service (Amazon ECS) is a highly scalable, fast, container management service. It makes it easy to run, stop, and manage Docker containers. You can host your cluster on a serverless infrastructure that's managed by Amazon ECS by launching your services or tasks on Fargate. For more control, you can host your tasks on a cluster of Amazon Elastic Compute Cloud (Amazon EC2) or External (on-premises) instances that you manage.
 *
 * Amazon ECS makes it easy to launch and stop container-based applications with simple API calls. This makes it easy to get the state of your cluster from a centralized service, and gives you access to many familiar Amazon EC2 features.
 *
 * You can use Amazon ECS to schedule the placement of containers across your cluster based on your resource needs, isolation policies, and availability requirements. With Amazon ECS, you don't need to operate your own cluster management and configuration management systems. You also don't need to worry about scaling your management infrastructure.
 */
public interface EcsClient : SdkClient {
    /**
     * EcsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EcsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Ecs",
                "ECS",
                "ecs",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EcsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EcsClient = DefaultEcsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EcsEndpointProvider = builder.endpointProvider ?: DefaultEcsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EcsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEcsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ECS"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EcsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EcsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.
     *
     * Only capacity providers that use an Auto Scaling group can be created. Amazon ECS tasks on Fargate use the `FARGATE` and `FARGATE_SPOT` capacity providers. These providers are available to all accounts in the Amazon Web Services Regions that Fargate supports.
     */
    public suspend fun createCapacityProvider(input: CreateCapacityProviderRequest): CreateCapacityProviderResponse

    /**
     * Creates a new Amazon ECS cluster. By default, your account receives a `default` cluster when you launch your first container instance. However, you can create your own cluster with a unique name with the `CreateCluster` action.
     *
     * When you call the CreateCluster API operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account. This is so that it can manage required resources in other Amazon Web Services services on your behalf. However, if the user that makes the call doesn't have permissions to create the service-linked role, it isn't created. For more information, see [Using service-linked roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.CreateCluster.sample
     */
    public suspend fun createCluster(input: CreateClusterRequest = CreateClusterRequest { }): CreateClusterResponse

    /**
     * Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running in a service drops below the `desiredCount`, Amazon ECS runs another copy of the task in the specified cluster. To update an existing service, see the UpdateService action.
     *
     * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
     *
     * In addition to maintaining the desired count of tasks in your service, you can optionally run your service behind one or more load balancers. The load balancers distribute traffic across the tasks that are associated with the service. For more information, see [Service load balancing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a service. `volumeConfigurations` is only supported for REPLICA service and not DAEMON service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Tasks for services that don't use a load balancer are considered healthy if they're in the `RUNNING` state. Tasks for services that use a load balancer are considered healthy if they're in the `RUNNING` state and are reported as healthy by the load balancer.
     *
     * There are two service scheduler strategies available:
     * + `REPLICA` - The replica scheduling strategy places and maintains your desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. For more information, see [Service scheduler concepts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) in the *Amazon Elastic Container Service Developer Guide*.
     * + `DAEMON` - The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks. It also stops tasks that don't meet the placement constraints. When using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies. For more information, see [Service scheduler concepts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * You can optionally specify a deployment configuration for your service. The deployment is initiated by changing properties. For example, the deployment might be initiated by the task definition or by your desired count of a service. This is done with an UpdateService operation. The default value for a replica service for `minimumHealthyPercent` is 100%. The default value for a daemon service for `minimumHealthyPercent` is 0%.
     *
     * If a service uses the `ECS` deployment controller, the minimum healthy percent represents a lower limit on the number of tasks in a service that must remain in the `RUNNING` state during a deployment. Specifically, it represents it as a percentage of your desired number of tasks (rounded up to the nearest integer). This happens when any of your container instances are in the `DRAINING` state if the service contains tasks using the EC2 launch type. Using this parameter, you can deploy without using additional cluster capacity. For example, if you set your service to have desired number of four tasks and a minimum healthy percent of 50%, the scheduler might stop two existing tasks to free up cluster capacity before starting two new tasks. If they're in the `RUNNING` state, tasks for services that don't use a load balancer are considered healthy . If they're in the `RUNNING` state and reported as healthy by the load balancer, tasks for services that *do* use a load balancer are considered healthy . The default value for minimum healthy percent is 100%.
     *
     * If a service uses the `ECS` deployment controller, the **maximum percent** parameter represents an upper limit on the number of tasks in a service that are allowed in the `RUNNING` or `PENDING` state during a deployment. Specifically, it represents it as a percentage of the desired number of tasks (rounded down to the nearest integer). This happens when any of your container instances are in the `DRAINING` state if the service contains tasks using the EC2 launch type. Using this parameter, you can define the deployment batch size. For example, if your service has a desired number of four tasks and a maximum percent value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default value for maximum percent is 200%.
     *
     * If a service uses either the `CODE_DEPLOY` or `EXTERNAL` deployment controller types and tasks that use the EC2 launch type, the **minimum healthy percent** and **maximum percent** values are used only to define the lower and upper limit on the number of the tasks in the service that remain in the `RUNNING` state. This is while the container instances are in the `DRAINING` state. If the tasks in the service use the Fargate launch type, the minimum healthy percent and maximum percent values aren't used. This is the case even if they're currently visible when describing your service.
     *
     * When creating a service that uses the `EXTERNAL` deployment controller, you can specify only parameters that aren't controlled at the task set level. The only required parameter is the service name. You control your services using the CreateTaskSet operation. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * When the service scheduler launches new tasks, it determines task placement. For information about task placement and task placement strategies, see [Amazon ECS task placement](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.CreateService.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.CreateService.sample2
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Create a task set in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For information about the maximum number of task sets and otther quotas, see [Amazon ECS service quotas](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-quotas.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun createTaskSet(input: CreateTaskSetRequest): CreateTaskSetResponse

    /**
     * Disables an account setting for a specified user, role, or the root user for an account.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DeleteAccountSetting.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.DeleteAccountSetting.sample2
     */
    public suspend fun deleteAccountSetting(input: DeleteAccountSettingRequest): DeleteAccountSettingResponse

    /**
     * Deletes one or more custom attributes from an Amazon ECS resource.
     */
    public suspend fun deleteAttributes(input: DeleteAttributesRequest): DeleteAttributesResponse

    /**
     * Deletes the specified capacity provider.
     *
     * The `FARGATE` and `FARGATE_SPOT` capacity providers are reserved and can't be deleted. You can disassociate them from a cluster using either the PutClusterCapacityProviders API or by deleting the cluster.
     *
     * Prior to a capacity provider being deleted, the capacity provider must be removed from the capacity provider strategy from all services. The UpdateService API can be used to remove a capacity provider from a service's capacity provider strategy. When updating a service, the `forceNewDeployment` option can be used to ensure that any tasks using the Amazon EC2 instance capacity provided by the capacity provider are transitioned to use the capacity from the remaining capacity providers. Only capacity providers that aren't associated with a cluster can be deleted. To remove a capacity provider from a cluster, you can either use PutClusterCapacityProviders or delete the cluster.
     */
    public suspend fun deleteCapacityProvider(input: DeleteCapacityProviderRequest): DeleteCapacityProviderResponse

    /**
     * Deletes the specified cluster. The cluster transitions to the `INACTIVE` state. Clusters with an `INACTIVE` status might remain discoverable in your account for a period of time. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` clusters persisting.
     *
     * You must deregister all container instances from this cluster before you may delete it. You can list the container instances in a cluster with ListContainerInstances and deregister them with DeregisterContainerInstance.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DeleteCluster.sample
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a specified service within a cluster. You can delete a service if you have no running tasks in it and the desired task count is zero. If the service is actively maintaining tasks, you can't delete it, and you must update the service to a desired task count of zero. For more information, see UpdateService.
     *
     * When you delete a service, if there are still running tasks that require cleanup, the service status moves from `ACTIVE` to `DRAINING`, and the service is no longer visible in the console or in the ListServices API operation. After all tasks have transitioned to either `STOPPING` or `STOPPED` status, the service status moves from `DRAINING` to `INACTIVE`. Services in the `DRAINING` or `INACTIVE` status can still be viewed with the DescribeServices API operation. However, in the future, `INACTIVE` services may be cleaned up and purged from Amazon ECS record keeping, and DescribeServices calls on those services return a `ServiceNotFoundException` error.
     *
     * If you attempt to create a new service with the same name as an existing service in either `ACTIVE` or `DRAINING` status, you receive an error.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DeleteService.sample
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Deletes one or more task definitions.
     *
     * You must deregister a task definition revision before you delete it. For more information, see [DeregisterTaskDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterTaskDefinition.html).
     *
     * When you delete a task definition revision, it is immediately transitions from the `INACTIVE` to `DELETE_IN_PROGRESS`. Existing tasks and services that reference a `DELETE_IN_PROGRESS` task definition revision continue to run without disruption. Existing services that reference a `DELETE_IN_PROGRESS` task definition revision can still scale up or down by modifying the service's desired count.
     *
     * You can't use a `DELETE_IN_PROGRESS` task definition revision to run new tasks or create new services. You also can't update an existing service to reference a `DELETE_IN_PROGRESS` task definition revision.
     *
     *  A task definition revision will stay in `DELETE_IN_PROGRESS` status until all the associated tasks and services have been terminated.
     *
     * When you delete all `INACTIVE` task definition revisions, the task definition name is not displayed in the console and not returned in the API. If a task definition revisions are in the `DELETE_IN_PROGRESS` state, the task definition name is displayed in the console and returned in the API. The task definition name is retained by Amazon ECS and the revision is incremented the next time you create a task definition with that name.
     */
    public suspend fun deleteTaskDefinitions(input: DeleteTaskDefinitionsRequest): DeleteTaskDefinitionsResponse

    /**
     * Deletes a specified task set within a service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun deleteTaskSet(input: DeleteTaskSetRequest): DeleteTaskSetResponse

    /**
     * Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to run tasks.
     *
     * If you intend to use the container instance for some other purpose after deregistration, we recommend that you stop all of the tasks running on the container instance before deregistration. That prevents any orphaned tasks from consuming resources.
     *
     * Deregistering a container instance removes the instance from a cluster, but it doesn't terminate the EC2 instance. If you are finished using the instance, be sure to terminate it in the Amazon EC2 console to stop billing.
     *
     * If you terminate a running container instance, Amazon ECS automatically deregisters the instance from your cluster (stopped container instances or instances with disconnected agents aren't automatically deregistered when terminated).
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DeregisterContainerInstance.sample
     */
    public suspend fun deregisterContainerInstance(input: DeregisterContainerInstanceRequest): DeregisterContainerInstanceResponse

    /**
     * Deregisters the specified task definition by family and revision. Upon deregistration, the task definition is marked as `INACTIVE`. Existing tasks and services that reference an `INACTIVE` task definition continue to run without disruption. Existing services that reference an `INACTIVE` task definition can still scale up or down by modifying the service's desired count. If you want to delete a task definition revision, you must first deregister the task definition revision.
     *
     * You can't use an `INACTIVE` task definition to run new tasks or create new services, and you can't update an existing service to reference an `INACTIVE` task definition. However, there may be up to a 10-minute window following deregistration where these restrictions have not yet taken effect.
     *
     * At this time, `INACTIVE` task definitions remain discoverable in your account indefinitely. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` task definitions persisting beyond the lifecycle of any associated tasks and services.
     *
     * You must deregister a task definition revision before you delete it. For more information, see [DeleteTaskDefinitions](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteTaskDefinitions.html).
     */
    public suspend fun deregisterTaskDefinition(input: DeregisterTaskDefinitionRequest): DeregisterTaskDefinitionResponse

    /**
     * Describes one or more of your capacity providers.
     */
    public suspend fun describeCapacityProviders(input: DescribeCapacityProvidersRequest = DescribeCapacityProvidersRequest { }): DescribeCapacityProvidersResponse

    /**
     * Describes one or more of your clusters.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DescribeClusters.sample
     */
    public suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest { }): DescribeClustersResponse

    /**
     * Describes one or more container instances. Returns metadata about each container instance requested.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DescribeContainerInstances.sample
     */
    public suspend fun describeContainerInstances(input: DescribeContainerInstancesRequest): DescribeContainerInstancesResponse

    /**
     * Describes the specified services running in your cluster.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DescribeServices.sample
     */
    public suspend fun describeServices(input: DescribeServicesRequest): DescribeServicesResponse

    /**
     * Describes a task definition. You can specify a `family` and `revision` to find information about a specific task definition, or you can simply specify the family to find the latest `ACTIVE` revision in that family.
     *
     * You can only describe `INACTIVE` task definitions while an active task or service references them.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DescribeTaskDefinition.sample
     */
    public suspend fun describeTaskDefinition(input: DescribeTaskDefinitionRequest): DescribeTaskDefinitionResponse

    /**
     * Describes the task sets in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun describeTaskSets(input: DescribeTaskSetsRequest): DescribeTaskSetsResponse

    /**
     * Describes a specified task or tasks.
     *
     * Currently, stopped tasks appear in the returned results for at least one hour.
     *
     * If you have tasks with tags, and then delete the cluster, the tagged tasks are returned in the response. If you create a new cluster with the same name as the deleted cluster, the tagged tasks are not included in the response.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.DescribeTasks.sample
     */
    public suspend fun describeTasks(input: DescribeTasksRequest): DescribeTasksResponse

    /**
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     *
     * Returns an endpoint for the Amazon ECS agent to poll for updates.
     */
    public suspend fun discoverPollEndpoint(input: DiscoverPollEndpointRequest = DiscoverPollEndpointRequest { }): DiscoverPollEndpointResponse

    /**
     * Runs a command remotely on a container within a task.
     *
     * If you use a condition key in your IAM policy to refine the conditions for the policy statement, for example limit the actions to a specific cluster, you receive an `AccessDeniedException` when there is a mismatch between the condition key value and the corresponding parameter value.
     *
     * For information about required permissions and considerations, see [Using Amazon ECS Exec for debugging](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html) in the *Amazon ECS Developer Guide*.
     */
    public suspend fun executeCommand(input: ExecuteCommandRequest): ExecuteCommandResponse

    /**
     * Retrieves the protection status of tasks in an Amazon ECS service.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.GetTaskProtection.sample
     */
    public suspend fun getTaskProtection(input: GetTaskProtectionRequest): GetTaskProtectionResponse

    /**
     * Lists the account settings for a specified principal.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListAccountSettings.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.ListAccountSettings.sample2
     */
    public suspend fun listAccountSettings(input: ListAccountSettingsRequest = ListAccountSettingsRequest { }): ListAccountSettingsResponse

    /**
     * Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a target type and cluster, `ListAttributes` returns a list of attribute objects, one for each attribute on each resource. You can filter the list of results to a single attribute name to only return results that have that name. You can also filter the results by attribute name and value. You can do this, for example, to see which container instances in a cluster are running a Linux AMI (`ecs.os-type=linux`).
     */
    public suspend fun listAttributes(input: ListAttributesRequest): ListAttributesResponse

    /**
     * Returns a list of existing clusters.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListClusters.sample
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest { }): ListClustersResponse

    /**
     * Returns a list of container instances in a specified cluster. You can filter the results of a `ListContainerInstances` operation with cluster query language statements inside the `filter` parameter. For more information, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListContainerInstances.sample
     */
    public suspend fun listContainerInstances(input: ListContainerInstancesRequest = ListContainerInstancesRequest { }): ListContainerInstancesResponse

    /**
     * Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListServices.sample
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest { }): ListServicesResponse

    /**
     * This operation lists all of the services that are associated with a Cloud Map namespace. This list might include services in different clusters. In contrast, `ListServices` can only list services in one cluster at a time. If you need to filter the list of services in a single cluster by various parameters, use `ListServices`. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun listServicesByNamespace(input: ListServicesByNamespaceRequest): ListServicesByNamespaceResponse

    /**
     * List the tags for an Amazon ECS resource.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of task definition families that are registered to your account. This list includes task definition families that no longer have any `ACTIVE` task definition revisions.
     *
     * You can filter out task definition families that don't contain any `ACTIVE` task definition revisions by setting the `status` parameter to `ACTIVE`. You can also filter the results with the `familyPrefix` parameter.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitionFamilies.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitionFamilies.sample2
     */
    public suspend fun listTaskDefinitionFamilies(input: ListTaskDefinitionFamiliesRequest = ListTaskDefinitionFamiliesRequest { }): ListTaskDefinitionFamiliesResponse

    /**
     * Returns a list of task definitions that are registered to your account. You can filter the results by family name with the `familyPrefix` parameter or by status with the `status` parameter.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitions.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitions.sample2
     */
    public suspend fun listTaskDefinitions(input: ListTaskDefinitionsRequest = ListTaskDefinitionsRequest { }): ListTaskDefinitionsResponse

    /**
     * Returns a list of tasks. You can filter the results by cluster, task definition family, container instance, launch type, what IAM principal started the task, or by the desired status of the task.
     *
     * Recently stopped tasks might appear in the returned results.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTasks.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.ListTasks.sample2
     */
    public suspend fun listTasks(input: ListTasksRequest = ListTasksRequest { }): ListTasksResponse

    /**
     * Modifies an account setting. Account settings are set on a per-Region basis.
     *
     * If you change the root user account setting, the default settings are reset for users and roles that do not have specified individual account settings. For more information, see [Account Settings](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * When you specify `serviceLongArnFormat`, `taskLongArnFormat`, or `containerInstanceLongArnFormat`, the Amazon Resource Name (ARN) and resource ID format of the resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource is defined by the opt-in status of the user or role that created the resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
     *
     * When you specify `awsvpcTrunking`, the elastic network interface (ENI) limit for any new container instances that support the feature is changed. If `awsvpcTrunking` is turned on, any new container instances that support the feature are launched have the increased ENI limits available to them. For more information, see [Elastic Network Interface Trunking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * When you specify `containerInsights`, the default setting indicating whether Amazon Web Services CloudWatch Container Insights is turned on for your clusters is changed. If `containerInsights` is turned on, any new clusters that are created will have Container Insights turned on unless you disable it during cluster creation. For more information, see [CloudWatch Container Insights](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Amazon ECS is introducing tagging authorization for resource creation. Users must have permissions for actions that create the resource, such as `ecsCreateCluster`. If tags are specified when you create a resource, Amazon Web Services performs additional authorization to verify if users or roles have permissions to create tags. Therefore, you must grant explicit permissions to use the `ecs:TagResource` action. For more information, see [Grant permission to tag resources on creation](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html) in the *Amazon ECS Developer Guide*.
     *
     * When Amazon Web Services determines that a security or infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and new tasks launched to replace them. Use `fargateTaskRetirementWaitPeriod` to configure the wait time to retire a Fargate task. For information about the Fargate tasks maintenance, see [Amazon Web Services Fargate task maintenance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html) in the *Amazon ECS Developer Guide*.
     *
     * The `guardDutyActivate` parameter is read-only in Amazon ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see [Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html).
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.PutAccountSetting.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.PutAccountSetting.sample2
     */
    public suspend fun putAccountSetting(input: PutAccountSettingRequest): PutAccountSettingResponse

    /**
     * Modifies an account setting for all users on an account for whom no individual account setting has been specified. Account settings are set on a per-Region basis.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.PutAccountSettingDefault.sample
     */
    public suspend fun putAccountSettingDefault(input: PutAccountSettingDefaultRequest): PutAccountSettingDefaultResponse

    /**
     * Create or update an attribute on an Amazon ECS resource. If the attribute doesn't exist, it's created. If the attribute exists, its value is replaced with the specified value. To delete an attribute, use DeleteAttributes. For more information, see [Attributes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun putAttributes(input: PutAttributesRequest): PutAttributesResponse

    /**
     * Modifies the available capacity providers and the default capacity provider strategy for a cluster.
     *
     * You must specify both the available capacity providers and a default capacity provider strategy for the cluster. If the specified cluster has existing capacity providers associated with it, you must specify all existing capacity providers in addition to any new ones you want to add. Any existing capacity providers that are associated with a cluster that are omitted from a PutClusterCapacityProviders API call will be disassociated with the cluster. You can only disassociate an existing capacity provider from a cluster if it's not being used by any existing tasks.
     *
     * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified, then the cluster's default capacity provider strategy is used. We recommend that you define a default capacity provider strategy for your cluster. However, you must specify an empty array (`[]`) to bypass defining a default strategy.
     */
    public suspend fun putClusterCapacityProviders(input: PutClusterCapacityProvidersRequest): PutClusterCapacityProvidersResponse

    /**
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     *
     * Registers an EC2 instance into the specified cluster. This instance becomes available to place containers on.
     */
    public suspend fun registerContainerInstance(input: RegisterContainerInstanceRequest = RegisterContainerInstanceRequest { }): RegisterContainerInstanceResponse

    /**
     * Registers a new task definition from the supplied `family` and `containerDefinitions`. Optionally, you can add data volumes to your containers with the `volumes` parameter. For more information about task definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * You can specify a role for your task with the `taskRoleArn` parameter. When you specify a role for a task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the Amazon Web Services services that are specified in the policy that's associated with the role. For more information, see [IAM Roles for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * You can specify a Docker networking mode for the containers in your task definition with the `networkMode` parameter. The available network modes correspond to those described in [Network settings](https://docs.docker.com/engine/reference/run/#/network-settings) in the Docker run reference. If you specify the `awsvpc` network mode, the task is allocated an elastic network interface, and you must specify a NetworkConfiguration when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.RegisterTaskDefinition.sample
     */
    public suspend fun registerTaskDefinition(input: RegisterTaskDefinitionRequest): RegisterTaskDefinitionResponse

    /**
     * Starts a new task using the specified task definition.
     *
     * You can allow Amazon ECS to place tasks for you, or you can customize how Amazon ECS places tasks using placement constraints and placement strategies. For more information, see [Scheduling Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Alternatively, you can use StartTask to use your own scheduler or place tasks manually on specific container instances.
     *
     * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
     *
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * The Amazon ECS API follows an eventual consistency model. This is because of the distributed nature of the system supporting the API. This means that the result of an API command you run that affects your Amazon ECS resources might not be immediately visible to all subsequent commands you run. Keep this in mind when you carry out an API command that immediately follows a previous API command.
     *
     * To manage eventual consistency, you can do the following:
     * + Confirm the state of the resource before you run a command to modify it. Run the DescribeTasks command using an exponential backoff algorithm to ensure that you allow enough time for the previous command to propagate through the system. To do this, run the DescribeTasks command repeatedly, starting with a couple of seconds of wait time and increasing gradually up to five minutes of wait time.
     * + Add wait time between subsequent commands, even if the DescribeTasks command returns an accurate response. Apply an exponential backoff algorithm starting with a couple of seconds of wait time, and increase gradually up to about five minutes of wait time.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.RunTask.sample
     */
    public suspend fun runTask(input: RunTaskRequest): RunTaskResponse

    /**
     * Starts a new task from the specified task definition on the specified container instance or instances.
     *
     * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
     *
     * Alternatively, you can use RunTask to place tasks for you. For more information, see [Scheduling Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun startTask(input: StartTaskRequest): StartTaskResponse

    /**
     * Stops a running task. Any tags associated with the task will be deleted.
     *
     * When StopTask is called on a task, the equivalent of `docker stop` is issued to the containers running in the task. This results in a `SIGTERM` value and a default 30-second timeout, after which the `SIGKILL` value is sent and the containers are forcibly stopped. If the container handles the `SIGTERM` value gracefully and exits within 30 seconds from receiving it, no `SIGKILL` value is sent.
     *
     * The default 30-second timeout can be configured on the Amazon ECS container agent with the `ECS_CONTAINER_STOP_TIMEOUT` variable. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun stopTask(input: StopTaskRequest): StopTaskResponse

    /**
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     *
     * Sent to acknowledge that an attachment changed states.
     */
    public suspend fun submitAttachmentStateChanges(input: SubmitAttachmentStateChangesRequest): SubmitAttachmentStateChangesResponse

    /**
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     *
     * Sent to acknowledge that a container changed states.
     */
    public suspend fun submitContainerStateChange(input: SubmitContainerStateChangeRequest = SubmitContainerStateChangeRequest { }): SubmitContainerStateChangeResponse

    /**
     * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
     *
     * Sent to acknowledge that a task changed states.
     */
    public suspend fun submitTaskStateChange(input: SubmitTaskStateChangeRequest = SubmitTaskStateChangeRequest { }): SubmitTaskStateChangeResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags that are associated with that resource are deleted as well.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Modifies the parameters for a capacity provider.
     */
    public suspend fun updateCapacityProvider(input: UpdateCapacityProviderRequest): UpdateCapacityProviderResponse

    /**
     * Updates the cluster.
     */
    public suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse

    /**
     * Modifies the settings to use for a cluster.
     */
    public suspend fun updateClusterSettings(input: UpdateClusterSettingsRequest): UpdateClusterSettingsResponse

    /**
     * Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent doesn't interrupt running tasks or services on the container instance. The process for updating the agent differs depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating system.
     *
     * The `UpdateContainerAgent` API isn't supported for container instances using the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI. To update the container agent, you can update the `ecs-init` package. This updates the agent. For more information, see [Updating the Amazon ECS container agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/agent-update-ecs-ami.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Agent updates with the `UpdateContainerAgent` API operation do not apply to Windows container instances. We recommend that you launch new container instances to update the agent version in your Windows clusters.
     *
     * The `UpdateContainerAgent` API requires an Amazon ECS-optimized AMI or Amazon Linux AMI with the `ecs-init` service installed and running. For help updating the Amazon ECS container agent on other operating systems, see [Manually updating the Amazon ECS container agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun updateContainerAgent(input: UpdateContainerAgentRequest): UpdateContainerAgentResponse

    /**
     * Modifies the status of an Amazon ECS container instance.
     *
     * Once a container instance has reached an `ACTIVE` state, you can change the status of a container instance to `DRAINING` to manually remove an instance from a cluster, for example to perform system updates, update the Docker daemon, or scale down the cluster size.
     *
     * A container instance can't be changed to `DRAINING` until it has reached an `ACTIVE` status. If the instance is in any other status, an error will be received.
     *
     * When you set a container instance to `DRAINING`, Amazon ECS prevents new tasks from being scheduled for placement on the container instance and replacement service tasks are started on other container instances in the cluster if the resources are available. Service tasks on the container instance that are in the `PENDING` state are stopped immediately.
     *
     * Service tasks on the container instance that are in the `RUNNING` state are stopped and replaced according to the service's deployment configuration parameters, `minimumHealthyPercent` and `maximumPercent`. You can change the deployment configuration of your service using UpdateService.
     * + If `minimumHealthyPercent` is below 100%, the scheduler can ignore `desiredCount` temporarily during task replacement. For example, `desiredCount` is four tasks, a minimum of 50% allows the scheduler to stop two existing tasks before starting two new tasks. If the minimum is 100%, the service scheduler can't remove existing tasks until the replacement tasks are considered healthy. Tasks for services that do not use a load balancer are considered healthy if they're in the `RUNNING` state. Tasks for services that use a load balancer are considered healthy if they're in the `RUNNING` state and are reported as healthy by the load balancer.
     * + The `maximumPercent` parameter represents an upper limit on the number of running tasks during task replacement. You can use this to define the replacement batch size. For example, if `desiredCount` is four tasks, a maximum of 200% starts four new tasks before stopping the four tasks to be drained, provided that the cluster resources required to do this are available. If the maximum is 100%, then replacement tasks can't start until the draining tasks have stopped.
     *
     * Any `PENDING` or `RUNNING` tasks that do not belong to a service aren't affected. You must wait for them to finish or stop them manually.
     *
     * A container instance has completed draining when it has no more `RUNNING` tasks. You can verify this using ListTasks.
     *
     * When a container instance has been drained, you can set a container instance to `ACTIVE` status and once it has reached that status the Amazon ECS scheduler can begin scheduling tasks on the instance again.
     */
    public suspend fun updateContainerInstancesState(input: UpdateContainerInstancesStateRequest): UpdateContainerInstancesStateResponse

    /**
     * Modifies the parameters of a service.
     *
     * For services using the rolling update (`ECS`) you can update the desired count, deployment configuration, network configuration, load balancers, service registries, enable ECS managed tags option, propagate tags option, task placement constraints and strategies, and task definition. When you update any of these parameters, Amazon ECS starts new tasks with the new configuration.
     *
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task, or when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*. You can update your volume configurations and trigger a new deployment. `volumeConfigurations` is only supported for REPLICA service and not DAEMON service. If you leave `volumeConfigurations``null`, it doesn't trigger a new deployment. For more infomation on volumes, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For services using the blue/green (`CODE_DEPLOY`) deployment controller, only the desired count, deployment configuration, health check grace period, task placement constraints and strategies, enable ECS managed tags option, and propagate tags can be updated using this API. If the network configuration, platform version, task definition, or load balancer need to be updated, create a new CodeDeploy deployment. For more information, see [CreateDeployment](https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html) in the *CodeDeploy API Reference*.
     *
     * For services using an external deployment controller, you can update only the desired count, task placement constraints and strategies, health check grace period, enable ECS managed tags option, and propagate tags option, using this API. If the launch type, load balancer, network configuration, platform version, or task definition need to be updated, create a new task set For more information, see CreateTaskSet.
     *
     * You can add to or subtract from the number of instantiations of a task definition in a service by specifying the cluster that the service is running in and a new `desiredCount` parameter.
     *
     * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task, or when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If you have updated the container image of your application, you can create a new task definition with that image and deploy it to your service. The service scheduler uses the minimum healthy percent and maximum percent parameters (in the service's deployment configuration) to determine the deployment strategy.
     *
     * If your updated Docker image uses the same tag as what is in the existing task definition for your service (for example, `my_image:latest`), you don't need to create a new revision of your task definition. You can update the service using the `forceNewDeployment` option. The new tasks launched by the deployment pull the current image/tag combination from your repository when they start.
     *
     * You can also update the deployment configuration of a service. When a deployment is triggered by updating the task definition of a service, the service scheduler uses the deployment configuration parameters, `minimumHealthyPercent` and `maximumPercent`, to determine the deployment strategy.
     * + If `minimumHealthyPercent` is below 100%, the scheduler can ignore `desiredCount` temporarily during a deployment. For example, if `desiredCount` is four tasks, a minimum of 50% allows the scheduler to stop two existing tasks before starting two new tasks. Tasks for services that don't use a load balancer are considered healthy if they're in the `RUNNING` state. Tasks for services that use a load balancer are considered healthy if they're in the `RUNNING` state and are reported as healthy by the load balancer.
     * + The `maximumPercent` parameter represents an upper limit on the number of running tasks during a deployment. You can use it to define the deployment batch size. For example, if `desiredCount` is four tasks, a maximum of 200% starts four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available).
     *
     * When UpdateService stops a task during a deployment, the equivalent of `docker stop` is issued to the containers running in the task. This results in a `SIGTERM` and a 30-second timeout. After this, `SIGKILL` is sent and the containers are forcibly stopped. If the container handles the `SIGTERM` gracefully and exits within 30 seconds from receiving it, no `SIGKILL` is sent.
     *
     * When the service scheduler launches new tasks, it determines task placement in your cluster with the following logic.
     * + Determine which of the container instances in your cluster can support your service's task definition. For example, they have the required CPU, memory, ports, and container instance attributes.
     * + By default, the service scheduler attempts to balance tasks across Availability Zones in this manner even though you can choose a different placement strategy.
     *    + Sort the valid container instances by the fewest number of running tasks for this service in the same Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each have zero, valid container instances in either zone B or C are considered optimal for placement.
     *    + Place the new service task on a valid container instance in an optimal Availability Zone (based on the previous steps), favoring container instances with the fewest number of running tasks for this service.
     *
     * When the service scheduler stops running tasks, it attempts to maintain balance across the Availability Zones in your cluster using the following logic:
     * + Sort the container instances by the largest number of running tasks for this service in the same Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each have two, container instances in either zone B or C are considered optimal for termination.
     * + Stop the task on a container instance in an optimal Availability Zone (based on the previous steps), favoring container instances with the largest number of running tasks for this service.
     *
     * You must have a service-linked role when you update any of the following service properties:
     * + `loadBalancers`,
     * + `serviceRegistries`
     * For more information about the role see the `CreateService` request parameter `role`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role).
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.UpdateService.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.UpdateService.sample2
     */
    public suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse

    /**
     * Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task set in a service will transition to the service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun updateServicePrimaryTaskSet(input: UpdateServicePrimaryTaskSetRequest): UpdateServicePrimaryTaskSetResponse

    /**
     * Updates the protection status of a task. You can set `protectionEnabled` to `true` to protect your task from termination during scale-in events from [Service Autoscaling](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html) or [deployments](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html).
     *
     * Task-protection, by default, expires after 2 hours at which point Amazon ECS clears the `protectionEnabled` property making the task eligible for termination by a subsequent scale-in event.
     *
     * You can specify a custom expiration period for task protection from 1 minute to up to 2,880 minutes (48 hours). To specify the custom expiration period, set the `expiresInMinutes` property. The `expiresInMinutes` property is always reset when you invoke this operation for a task that already has `protectionEnabled` set to `true`. You can keep extending the protection expiration period of a task by invoking this operation repeatedly.
     *
     * To learn more about Amazon ECS task protection, see [Task scale-in protection](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection.html) in the **Amazon Elastic Container Service Developer Guide**.
     *
     * This operation is only supported for tasks belonging to an Amazon ECS service. Invoking this operation for a standalone task will result in an `TASK_NOT_VALID` failure. For more information, see [API failure reasons](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html).
     *
     * If you prefer to set task protection from within the container, we recommend using the [Task scale-in protection endpoint](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection-endpoint.html).
     *
     * @sample aws.sdk.kotlin.services.ecs.samples.UpdateTaskProtection.sample
     * @sample aws.sdk.kotlin.services.ecs.samples.UpdateTaskProtection.sample2
     * @sample aws.sdk.kotlin.services.ecs.samples.UpdateTaskProtection.sample3
     */
    public suspend fun updateTaskProtection(input: UpdateTaskProtectionRequest): UpdateTaskProtectionResponse

    /**
     * Modifies a task set. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public suspend fun updateTaskSet(input: UpdateTaskSetRequest): UpdateTaskSetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EcsClient.withConfig(block: EcsClient.Config.Builder.() -> Unit): EcsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEcsClient(newConfig)
}

/**
 * Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.
 *
 * Only capacity providers that use an Auto Scaling group can be created. Amazon ECS tasks on Fargate use the `FARGATE` and `FARGATE_SPOT` capacity providers. These providers are available to all accounts in the Amazon Web Services Regions that Fargate supports.
 */
public suspend inline fun EcsClient.createCapacityProvider(crossinline block: CreateCapacityProviderRequest.Builder.() -> Unit): CreateCapacityProviderResponse = createCapacityProvider(CreateCapacityProviderRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon ECS cluster. By default, your account receives a `default` cluster when you launch your first container instance. However, you can create your own cluster with a unique name with the `CreateCluster` action.
 *
 * When you call the CreateCluster API operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account. This is so that it can manage required resources in other Amazon Web Services services on your behalf. However, if the user that makes the call doesn't have permissions to create the service-linked role, it isn't created. For more information, see [Using service-linked roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.CreateCluster.sample
 */
public suspend inline fun EcsClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running in a service drops below the `desiredCount`, Amazon ECS runs another copy of the task in the specified cluster. To update an existing service, see the UpdateService action.
 *
 * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
 *
 * In addition to maintaining the desired count of tasks in your service, you can optionally run your service behind one or more load balancers. The load balancers distribute traffic across the tasks that are associated with the service. For more information, see [Service load balancing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a service. `volumeConfigurations` is only supported for REPLICA service and not DAEMON service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * Tasks for services that don't use a load balancer are considered healthy if they're in the `RUNNING` state. Tasks for services that use a load balancer are considered healthy if they're in the `RUNNING` state and are reported as healthy by the load balancer.
 *
 * There are two service scheduler strategies available:
 * + `REPLICA` - The replica scheduling strategy places and maintains your desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. For more information, see [Service scheduler concepts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) in the *Amazon Elastic Container Service Developer Guide*.
 * + `DAEMON` - The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks. It also stops tasks that don't meet the placement constraints. When using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies. For more information, see [Service scheduler concepts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * You can optionally specify a deployment configuration for your service. The deployment is initiated by changing properties. For example, the deployment might be initiated by the task definition or by your desired count of a service. This is done with an UpdateService operation. The default value for a replica service for `minimumHealthyPercent` is 100%. The default value for a daemon service for `minimumHealthyPercent` is 0%.
 *
 * If a service uses the `ECS` deployment controller, the minimum healthy percent represents a lower limit on the number of tasks in a service that must remain in the `RUNNING` state during a deployment. Specifically, it represents it as a percentage of your desired number of tasks (rounded up to the nearest integer). This happens when any of your container instances are in the `DRAINING` state if the service contains tasks using the EC2 launch type. Using this parameter, you can deploy without using additional cluster capacity. For example, if you set your service to have desired number of four tasks and a minimum healthy percent of 50%, the scheduler might stop two existing tasks to free up cluster capacity before starting two new tasks. If they're in the `RUNNING` state, tasks for services that don't use a load balancer are considered healthy . If they're in the `RUNNING` state and reported as healthy by the load balancer, tasks for services that *do* use a load balancer are considered healthy . The default value for minimum healthy percent is 100%.
 *
 * If a service uses the `ECS` deployment controller, the **maximum percent** parameter represents an upper limit on the number of tasks in a service that are allowed in the `RUNNING` or `PENDING` state during a deployment. Specifically, it represents it as a percentage of the desired number of tasks (rounded down to the nearest integer). This happens when any of your container instances are in the `DRAINING` state if the service contains tasks using the EC2 launch type. Using this parameter, you can define the deployment batch size. For example, if your service has a desired number of four tasks and a maximum percent value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default value for maximum percent is 200%.
 *
 * If a service uses either the `CODE_DEPLOY` or `EXTERNAL` deployment controller types and tasks that use the EC2 launch type, the **minimum healthy percent** and **maximum percent** values are used only to define the lower and upper limit on the number of the tasks in the service that remain in the `RUNNING` state. This is while the container instances are in the `DRAINING` state. If the tasks in the service use the Fargate launch type, the minimum healthy percent and maximum percent values aren't used. This is the case even if they're currently visible when describing your service.
 *
 * When creating a service that uses the `EXTERNAL` deployment controller, you can specify only parameters that aren't controlled at the task set level. The only required parameter is the service name. You control your services using the CreateTaskSet operation. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * When the service scheduler launches new tasks, it determines task placement. For information about task placement and task placement strategies, see [Amazon ECS task placement](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.CreateService.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.CreateService.sample2
 */
public suspend inline fun EcsClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Create a task set in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * For information about the maximum number of task sets and otther quotas, see [Amazon ECS service quotas](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-quotas.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.createTaskSet(crossinline block: CreateTaskSetRequest.Builder.() -> Unit): CreateTaskSetResponse = createTaskSet(CreateTaskSetRequest.Builder().apply(block).build())

/**
 * Disables an account setting for a specified user, role, or the root user for an account.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DeleteAccountSetting.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.DeleteAccountSetting.sample2
 */
public suspend inline fun EcsClient.deleteAccountSetting(crossinline block: DeleteAccountSettingRequest.Builder.() -> Unit): DeleteAccountSettingResponse = deleteAccountSetting(DeleteAccountSettingRequest.Builder().apply(block).build())

/**
 * Deletes one or more custom attributes from an Amazon ECS resource.
 */
public suspend inline fun EcsClient.deleteAttributes(crossinline block: DeleteAttributesRequest.Builder.() -> Unit): DeleteAttributesResponse = deleteAttributes(DeleteAttributesRequest.Builder().apply(block).build())

/**
 * Deletes the specified capacity provider.
 *
 * The `FARGATE` and `FARGATE_SPOT` capacity providers are reserved and can't be deleted. You can disassociate them from a cluster using either the PutClusterCapacityProviders API or by deleting the cluster.
 *
 * Prior to a capacity provider being deleted, the capacity provider must be removed from the capacity provider strategy from all services. The UpdateService API can be used to remove a capacity provider from a service's capacity provider strategy. When updating a service, the `forceNewDeployment` option can be used to ensure that any tasks using the Amazon EC2 instance capacity provided by the capacity provider are transitioned to use the capacity from the remaining capacity providers. Only capacity providers that aren't associated with a cluster can be deleted. To remove a capacity provider from a cluster, you can either use PutClusterCapacityProviders or delete the cluster.
 */
public suspend inline fun EcsClient.deleteCapacityProvider(crossinline block: DeleteCapacityProviderRequest.Builder.() -> Unit): DeleteCapacityProviderResponse = deleteCapacityProvider(DeleteCapacityProviderRequest.Builder().apply(block).build())

/**
 * Deletes the specified cluster. The cluster transitions to the `INACTIVE` state. Clusters with an `INACTIVE` status might remain discoverable in your account for a period of time. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` clusters persisting.
 *
 * You must deregister all container instances from this cluster before you may delete it. You can list the container instances in a cluster with ListContainerInstances and deregister them with DeregisterContainerInstance.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DeleteCluster.sample
 */
public suspend inline fun EcsClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes a specified service within a cluster. You can delete a service if you have no running tasks in it and the desired task count is zero. If the service is actively maintaining tasks, you can't delete it, and you must update the service to a desired task count of zero. For more information, see UpdateService.
 *
 * When you delete a service, if there are still running tasks that require cleanup, the service status moves from `ACTIVE` to `DRAINING`, and the service is no longer visible in the console or in the ListServices API operation. After all tasks have transitioned to either `STOPPING` or `STOPPED` status, the service status moves from `DRAINING` to `INACTIVE`. Services in the `DRAINING` or `INACTIVE` status can still be viewed with the DescribeServices API operation. However, in the future, `INACTIVE` services may be cleaned up and purged from Amazon ECS record keeping, and DescribeServices calls on those services return a `ServiceNotFoundException` error.
 *
 * If you attempt to create a new service with the same name as an existing service in either `ACTIVE` or `DRAINING` status, you receive an error.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DeleteService.sample
 */
public suspend inline fun EcsClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Deletes one or more task definitions.
 *
 * You must deregister a task definition revision before you delete it. For more information, see [DeregisterTaskDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeregisterTaskDefinition.html).
 *
 * When you delete a task definition revision, it is immediately transitions from the `INACTIVE` to `DELETE_IN_PROGRESS`. Existing tasks and services that reference a `DELETE_IN_PROGRESS` task definition revision continue to run without disruption. Existing services that reference a `DELETE_IN_PROGRESS` task definition revision can still scale up or down by modifying the service's desired count.
 *
 * You can't use a `DELETE_IN_PROGRESS` task definition revision to run new tasks or create new services. You also can't update an existing service to reference a `DELETE_IN_PROGRESS` task definition revision.
 *
 *  A task definition revision will stay in `DELETE_IN_PROGRESS` status until all the associated tasks and services have been terminated.
 *
 * When you delete all `INACTIVE` task definition revisions, the task definition name is not displayed in the console and not returned in the API. If a task definition revisions are in the `DELETE_IN_PROGRESS` state, the task definition name is displayed in the console and returned in the API. The task definition name is retained by Amazon ECS and the revision is incremented the next time you create a task definition with that name.
 */
public suspend inline fun EcsClient.deleteTaskDefinitions(crossinline block: DeleteTaskDefinitionsRequest.Builder.() -> Unit): DeleteTaskDefinitionsResponse = deleteTaskDefinitions(DeleteTaskDefinitionsRequest.Builder().apply(block).build())

/**
 * Deletes a specified task set within a service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.deleteTaskSet(crossinline block: DeleteTaskSetRequest.Builder.() -> Unit): DeleteTaskSetResponse = deleteTaskSet(DeleteTaskSetRequest.Builder().apply(block).build())

/**
 * Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to run tasks.
 *
 * If you intend to use the container instance for some other purpose after deregistration, we recommend that you stop all of the tasks running on the container instance before deregistration. That prevents any orphaned tasks from consuming resources.
 *
 * Deregistering a container instance removes the instance from a cluster, but it doesn't terminate the EC2 instance. If you are finished using the instance, be sure to terminate it in the Amazon EC2 console to stop billing.
 *
 * If you terminate a running container instance, Amazon ECS automatically deregisters the instance from your cluster (stopped container instances or instances with disconnected agents aren't automatically deregistered when terminated).
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DeregisterContainerInstance.sample
 */
public suspend inline fun EcsClient.deregisterContainerInstance(crossinline block: DeregisterContainerInstanceRequest.Builder.() -> Unit): DeregisterContainerInstanceResponse = deregisterContainerInstance(DeregisterContainerInstanceRequest.Builder().apply(block).build())

/**
 * Deregisters the specified task definition by family and revision. Upon deregistration, the task definition is marked as `INACTIVE`. Existing tasks and services that reference an `INACTIVE` task definition continue to run without disruption. Existing services that reference an `INACTIVE` task definition can still scale up or down by modifying the service's desired count. If you want to delete a task definition revision, you must first deregister the task definition revision.
 *
 * You can't use an `INACTIVE` task definition to run new tasks or create new services, and you can't update an existing service to reference an `INACTIVE` task definition. However, there may be up to a 10-minute window following deregistration where these restrictions have not yet taken effect.
 *
 * At this time, `INACTIVE` task definitions remain discoverable in your account indefinitely. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` task definitions persisting beyond the lifecycle of any associated tasks and services.
 *
 * You must deregister a task definition revision before you delete it. For more information, see [DeleteTaskDefinitions](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeleteTaskDefinitions.html).
 */
public suspend inline fun EcsClient.deregisterTaskDefinition(crossinline block: DeregisterTaskDefinitionRequest.Builder.() -> Unit): DeregisterTaskDefinitionResponse = deregisterTaskDefinition(DeregisterTaskDefinitionRequest.Builder().apply(block).build())

/**
 * Describes one or more of your capacity providers.
 */
public suspend inline fun EcsClient.describeCapacityProviders(crossinline block: DescribeCapacityProvidersRequest.Builder.() -> Unit): DescribeCapacityProvidersResponse = describeCapacityProviders(DescribeCapacityProvidersRequest.Builder().apply(block).build())

/**
 * Describes one or more of your clusters.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DescribeClusters.sample
 */
public suspend inline fun EcsClient.describeClusters(crossinline block: DescribeClustersRequest.Builder.() -> Unit): DescribeClustersResponse = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

/**
 * Describes one or more container instances. Returns metadata about each container instance requested.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DescribeContainerInstances.sample
 */
public suspend inline fun EcsClient.describeContainerInstances(crossinline block: DescribeContainerInstancesRequest.Builder.() -> Unit): DescribeContainerInstancesResponse = describeContainerInstances(DescribeContainerInstancesRequest.Builder().apply(block).build())

/**
 * Describes the specified services running in your cluster.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DescribeServices.sample
 */
public suspend inline fun EcsClient.describeServices(crossinline block: DescribeServicesRequest.Builder.() -> Unit): DescribeServicesResponse = describeServices(DescribeServicesRequest.Builder().apply(block).build())

/**
 * Describes a task definition. You can specify a `family` and `revision` to find information about a specific task definition, or you can simply specify the family to find the latest `ACTIVE` revision in that family.
 *
 * You can only describe `INACTIVE` task definitions while an active task or service references them.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DescribeTaskDefinition.sample
 */
public suspend inline fun EcsClient.describeTaskDefinition(crossinline block: DescribeTaskDefinitionRequest.Builder.() -> Unit): DescribeTaskDefinitionResponse = describeTaskDefinition(DescribeTaskDefinitionRequest.Builder().apply(block).build())

/**
 * Describes the task sets in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.describeTaskSets(crossinline block: DescribeTaskSetsRequest.Builder.() -> Unit): DescribeTaskSetsResponse = describeTaskSets(DescribeTaskSetsRequest.Builder().apply(block).build())

/**
 * Describes a specified task or tasks.
 *
 * Currently, stopped tasks appear in the returned results for at least one hour.
 *
 * If you have tasks with tags, and then delete the cluster, the tagged tasks are returned in the response. If you create a new cluster with the same name as the deleted cluster, the tagged tasks are not included in the response.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.DescribeTasks.sample
 */
public suspend inline fun EcsClient.describeTasks(crossinline block: DescribeTasksRequest.Builder.() -> Unit): DescribeTasksResponse = describeTasks(DescribeTasksRequest.Builder().apply(block).build())

/**
 * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
 *
 * Returns an endpoint for the Amazon ECS agent to poll for updates.
 */
public suspend inline fun EcsClient.discoverPollEndpoint(crossinline block: DiscoverPollEndpointRequest.Builder.() -> Unit): DiscoverPollEndpointResponse = discoverPollEndpoint(DiscoverPollEndpointRequest.Builder().apply(block).build())

/**
 * Runs a command remotely on a container within a task.
 *
 * If you use a condition key in your IAM policy to refine the conditions for the policy statement, for example limit the actions to a specific cluster, you receive an `AccessDeniedException` when there is a mismatch between the condition key value and the corresponding parameter value.
 *
 * For information about required permissions and considerations, see [Using Amazon ECS Exec for debugging](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html) in the *Amazon ECS Developer Guide*.
 */
public suspend inline fun EcsClient.executeCommand(crossinline block: ExecuteCommandRequest.Builder.() -> Unit): ExecuteCommandResponse = executeCommand(ExecuteCommandRequest.Builder().apply(block).build())

/**
 * Retrieves the protection status of tasks in an Amazon ECS service.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.GetTaskProtection.sample
 */
public suspend inline fun EcsClient.getTaskProtection(crossinline block: GetTaskProtectionRequest.Builder.() -> Unit): GetTaskProtectionResponse = getTaskProtection(GetTaskProtectionRequest.Builder().apply(block).build())

/**
 * Lists the account settings for a specified principal.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListAccountSettings.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.ListAccountSettings.sample2
 */
public suspend inline fun EcsClient.listAccountSettings(crossinline block: ListAccountSettingsRequest.Builder.() -> Unit): ListAccountSettingsResponse = listAccountSettings(ListAccountSettingsRequest.Builder().apply(block).build())

/**
 * Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a target type and cluster, `ListAttributes` returns a list of attribute objects, one for each attribute on each resource. You can filter the list of results to a single attribute name to only return results that have that name. You can also filter the results by attribute name and value. You can do this, for example, to see which container instances in a cluster are running a Linux AMI (`ecs.os-type=linux`).
 */
public suspend inline fun EcsClient.listAttributes(crossinline block: ListAttributesRequest.Builder.() -> Unit): ListAttributesResponse = listAttributes(ListAttributesRequest.Builder().apply(block).build())

/**
 * Returns a list of existing clusters.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListClusters.sample
 */
public suspend inline fun EcsClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of container instances in a specified cluster. You can filter the results of a `ListContainerInstances` operation with cluster query language statements inside the `filter` parameter. For more information, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListContainerInstances.sample
 */
public suspend inline fun EcsClient.listContainerInstances(crossinline block: ListContainerInstancesRequest.Builder.() -> Unit): ListContainerInstancesResponse = listContainerInstances(ListContainerInstancesRequest.Builder().apply(block).build())

/**
 * Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListServices.sample
 */
public suspend inline fun EcsClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * This operation lists all of the services that are associated with a Cloud Map namespace. This list might include services in different clusters. In contrast, `ListServices` can only list services in one cluster at a time. If you need to filter the list of services in a single cluster by various parameters, use `ListServices`. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.listServicesByNamespace(crossinline block: ListServicesByNamespaceRequest.Builder.() -> Unit): ListServicesByNamespaceResponse = listServicesByNamespace(ListServicesByNamespaceRequest.Builder().apply(block).build())

/**
 * List the tags for an Amazon ECS resource.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTagsForResource.sample
 */
public suspend inline fun EcsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of task definition families that are registered to your account. This list includes task definition families that no longer have any `ACTIVE` task definition revisions.
 *
 * You can filter out task definition families that don't contain any `ACTIVE` task definition revisions by setting the `status` parameter to `ACTIVE`. You can also filter the results with the `familyPrefix` parameter.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitionFamilies.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitionFamilies.sample2
 */
public suspend inline fun EcsClient.listTaskDefinitionFamilies(crossinline block: ListTaskDefinitionFamiliesRequest.Builder.() -> Unit): ListTaskDefinitionFamiliesResponse = listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest.Builder().apply(block).build())

/**
 * Returns a list of task definitions that are registered to your account. You can filter the results by family name with the `familyPrefix` parameter or by status with the `status` parameter.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitions.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTaskDefinitions.sample2
 */
public suspend inline fun EcsClient.listTaskDefinitions(crossinline block: ListTaskDefinitionsRequest.Builder.() -> Unit): ListTaskDefinitionsResponse = listTaskDefinitions(ListTaskDefinitionsRequest.Builder().apply(block).build())

/**
 * Returns a list of tasks. You can filter the results by cluster, task definition family, container instance, launch type, what IAM principal started the task, or by the desired status of the task.
 *
 * Recently stopped tasks might appear in the returned results.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTasks.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.ListTasks.sample2
 */
public suspend inline fun EcsClient.listTasks(crossinline block: ListTasksRequest.Builder.() -> Unit): ListTasksResponse = listTasks(ListTasksRequest.Builder().apply(block).build())

/**
 * Modifies an account setting. Account settings are set on a per-Region basis.
 *
 * If you change the root user account setting, the default settings are reset for users and roles that do not have specified individual account settings. For more information, see [Account Settings](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * When you specify `serviceLongArnFormat`, `taskLongArnFormat`, or `containerInstanceLongArnFormat`, the Amazon Resource Name (ARN) and resource ID format of the resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource is defined by the opt-in status of the user or role that created the resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
 *
 * When you specify `awsvpcTrunking`, the elastic network interface (ENI) limit for any new container instances that support the feature is changed. If `awsvpcTrunking` is turned on, any new container instances that support the feature are launched have the increased ENI limits available to them. For more information, see [Elastic Network Interface Trunking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * When you specify `containerInsights`, the default setting indicating whether Amazon Web Services CloudWatch Container Insights is turned on for your clusters is changed. If `containerInsights` is turned on, any new clusters that are created will have Container Insights turned on unless you disable it during cluster creation. For more information, see [CloudWatch Container Insights](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * Amazon ECS is introducing tagging authorization for resource creation. Users must have permissions for actions that create the resource, such as `ecsCreateCluster`. If tags are specified when you create a resource, Amazon Web Services performs additional authorization to verify if users or roles have permissions to create tags. Therefore, you must grant explicit permissions to use the `ecs:TagResource` action. For more information, see [Grant permission to tag resources on creation](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html) in the *Amazon ECS Developer Guide*.
 *
 * When Amazon Web Services determines that a security or infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and new tasks launched to replace them. Use `fargateTaskRetirementWaitPeriod` to configure the wait time to retire a Fargate task. For information about the Fargate tasks maintenance, see [Amazon Web Services Fargate task maintenance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html) in the *Amazon ECS Developer Guide*.
 *
 * The `guardDutyActivate` parameter is read-only in Amazon ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see [Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html).
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.PutAccountSetting.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.PutAccountSetting.sample2
 */
public suspend inline fun EcsClient.putAccountSetting(crossinline block: PutAccountSettingRequest.Builder.() -> Unit): PutAccountSettingResponse = putAccountSetting(PutAccountSettingRequest.Builder().apply(block).build())

/**
 * Modifies an account setting for all users on an account for whom no individual account setting has been specified. Account settings are set on a per-Region basis.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.PutAccountSettingDefault.sample
 */
public suspend inline fun EcsClient.putAccountSettingDefault(crossinline block: PutAccountSettingDefaultRequest.Builder.() -> Unit): PutAccountSettingDefaultResponse = putAccountSettingDefault(PutAccountSettingDefaultRequest.Builder().apply(block).build())

/**
 * Create or update an attribute on an Amazon ECS resource. If the attribute doesn't exist, it's created. If the attribute exists, its value is replaced with the specified value. To delete an attribute, use DeleteAttributes. For more information, see [Attributes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.putAttributes(crossinline block: PutAttributesRequest.Builder.() -> Unit): PutAttributesResponse = putAttributes(PutAttributesRequest.Builder().apply(block).build())

/**
 * Modifies the available capacity providers and the default capacity provider strategy for a cluster.
 *
 * You must specify both the available capacity providers and a default capacity provider strategy for the cluster. If the specified cluster has existing capacity providers associated with it, you must specify all existing capacity providers in addition to any new ones you want to add. Any existing capacity providers that are associated with a cluster that are omitted from a PutClusterCapacityProviders API call will be disassociated with the cluster. You can only disassociate an existing capacity provider from a cluster if it's not being used by any existing tasks.
 *
 * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified, then the cluster's default capacity provider strategy is used. We recommend that you define a default capacity provider strategy for your cluster. However, you must specify an empty array (`[]`) to bypass defining a default strategy.
 */
public suspend inline fun EcsClient.putClusterCapacityProviders(crossinline block: PutClusterCapacityProvidersRequest.Builder.() -> Unit): PutClusterCapacityProvidersResponse = putClusterCapacityProviders(PutClusterCapacityProvidersRequest.Builder().apply(block).build())

/**
 * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
 *
 * Registers an EC2 instance into the specified cluster. This instance becomes available to place containers on.
 */
public suspend inline fun EcsClient.registerContainerInstance(crossinline block: RegisterContainerInstanceRequest.Builder.() -> Unit): RegisterContainerInstanceResponse = registerContainerInstance(RegisterContainerInstanceRequest.Builder().apply(block).build())

/**
 * Registers a new task definition from the supplied `family` and `containerDefinitions`. Optionally, you can add data volumes to your containers with the `volumes` parameter. For more information about task definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * You can specify a role for your task with the `taskRoleArn` parameter. When you specify a role for a task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the Amazon Web Services services that are specified in the policy that's associated with the role. For more information, see [IAM Roles for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * You can specify a Docker networking mode for the containers in your task definition with the `networkMode` parameter. The available network modes correspond to those described in [Network settings](https://docs.docker.com/engine/reference/run/#/network-settings) in the Docker run reference. If you specify the `awsvpc` network mode, the task is allocated an elastic network interface, and you must specify a NetworkConfiguration when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.RegisterTaskDefinition.sample
 */
public suspend inline fun EcsClient.registerTaskDefinition(crossinline block: RegisterTaskDefinitionRequest.Builder.() -> Unit): RegisterTaskDefinitionResponse = registerTaskDefinition(RegisterTaskDefinitionRequest.Builder().apply(block).build())

/**
 * Starts a new task using the specified task definition.
 *
 * You can allow Amazon ECS to place tasks for you, or you can customize how Amazon ECS places tasks using placement constraints and placement strategies. For more information, see [Scheduling Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * Alternatively, you can use StartTask to use your own scheduler or place tasks manually on specific container instances.
 *
 * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
 *
 * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * The Amazon ECS API follows an eventual consistency model. This is because of the distributed nature of the system supporting the API. This means that the result of an API command you run that affects your Amazon ECS resources might not be immediately visible to all subsequent commands you run. Keep this in mind when you carry out an API command that immediately follows a previous API command.
 *
 * To manage eventual consistency, you can do the following:
 * + Confirm the state of the resource before you run a command to modify it. Run the DescribeTasks command using an exponential backoff algorithm to ensure that you allow enough time for the previous command to propagate through the system. To do this, run the DescribeTasks command repeatedly, starting with a couple of seconds of wait time and increasing gradually up to five minutes of wait time.
 * + Add wait time between subsequent commands, even if the DescribeTasks command returns an accurate response. Apply an exponential backoff algorithm starting with a couple of seconds of wait time, and increase gradually up to about five minutes of wait time.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.RunTask.sample
 */
public suspend inline fun EcsClient.runTask(crossinline block: RunTaskRequest.Builder.() -> Unit): RunTaskResponse = runTask(RunTaskRequest.Builder().apply(block).build())

/**
 * Starts a new task from the specified task definition on the specified container instance or instances.
 *
 * Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
 *
 * Alternatively, you can use RunTask to place tasks for you. For more information, see [Scheduling Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.startTask(crossinline block: StartTaskRequest.Builder.() -> Unit): StartTaskResponse = startTask(StartTaskRequest.Builder().apply(block).build())

/**
 * Stops a running task. Any tags associated with the task will be deleted.
 *
 * When StopTask is called on a task, the equivalent of `docker stop` is issued to the containers running in the task. This results in a `SIGTERM` value and a default 30-second timeout, after which the `SIGKILL` value is sent and the containers are forcibly stopped. If the container handles the `SIGTERM` value gracefully and exits within 30 seconds from receiving it, no `SIGKILL` value is sent.
 *
 * The default 30-second timeout can be configured on the Amazon ECS container agent with the `ECS_CONTAINER_STOP_TIMEOUT` variable. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.stopTask(crossinline block: StopTaskRequest.Builder.() -> Unit): StopTaskResponse = stopTask(StopTaskRequest.Builder().apply(block).build())

/**
 * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
 *
 * Sent to acknowledge that an attachment changed states.
 */
public suspend inline fun EcsClient.submitAttachmentStateChanges(crossinline block: SubmitAttachmentStateChangesRequest.Builder.() -> Unit): SubmitAttachmentStateChangesResponse = submitAttachmentStateChanges(SubmitAttachmentStateChangesRequest.Builder().apply(block).build())

/**
 * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
 *
 * Sent to acknowledge that a container changed states.
 */
public suspend inline fun EcsClient.submitContainerStateChange(crossinline block: SubmitContainerStateChangeRequest.Builder.() -> Unit): SubmitContainerStateChangeResponse = submitContainerStateChange(SubmitContainerStateChangeRequest.Builder().apply(block).build())

/**
 * This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
 *
 * Sent to acknowledge that a task changed states.
 */
public suspend inline fun EcsClient.submitTaskStateChange(crossinline block: SubmitTaskStateChangeRequest.Builder.() -> Unit): SubmitTaskStateChangeResponse = submitTaskStateChange(SubmitTaskStateChangeRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags that are associated with that resource are deleted as well.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.TagResource.sample
 */
public suspend inline fun EcsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.UntagResource.sample
 */
public suspend inline fun EcsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Modifies the parameters for a capacity provider.
 */
public suspend inline fun EcsClient.updateCapacityProvider(crossinline block: UpdateCapacityProviderRequest.Builder.() -> Unit): UpdateCapacityProviderResponse = updateCapacityProvider(UpdateCapacityProviderRequest.Builder().apply(block).build())

/**
 * Updates the cluster.
 */
public suspend inline fun EcsClient.updateCluster(crossinline block: UpdateClusterRequest.Builder.() -> Unit): UpdateClusterResponse = updateCluster(UpdateClusterRequest.Builder().apply(block).build())

/**
 * Modifies the settings to use for a cluster.
 */
public suspend inline fun EcsClient.updateClusterSettings(crossinline block: UpdateClusterSettingsRequest.Builder.() -> Unit): UpdateClusterSettingsResponse = updateClusterSettings(UpdateClusterSettingsRequest.Builder().apply(block).build())

/**
 * Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent doesn't interrupt running tasks or services on the container instance. The process for updating the agent differs depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating system.
 *
 * The `UpdateContainerAgent` API isn't supported for container instances using the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI. To update the container agent, you can update the `ecs-init` package. This updates the agent. For more information, see [Updating the Amazon ECS container agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/agent-update-ecs-ami.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * Agent updates with the `UpdateContainerAgent` API operation do not apply to Windows container instances. We recommend that you launch new container instances to update the agent version in your Windows clusters.
 *
 * The `UpdateContainerAgent` API requires an Amazon ECS-optimized AMI or Amazon Linux AMI with the `ecs-init` service installed and running. For help updating the Amazon ECS container agent on other operating systems, see [Manually updating the Amazon ECS container agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.updateContainerAgent(crossinline block: UpdateContainerAgentRequest.Builder.() -> Unit): UpdateContainerAgentResponse = updateContainerAgent(UpdateContainerAgentRequest.Builder().apply(block).build())

/**
 * Modifies the status of an Amazon ECS container instance.
 *
 * Once a container instance has reached an `ACTIVE` state, you can change the status of a container instance to `DRAINING` to manually remove an instance from a cluster, for example to perform system updates, update the Docker daemon, or scale down the cluster size.
 *
 * A container instance can't be changed to `DRAINING` until it has reached an `ACTIVE` status. If the instance is in any other status, an error will be received.
 *
 * When you set a container instance to `DRAINING`, Amazon ECS prevents new tasks from being scheduled for placement on the container instance and replacement service tasks are started on other container instances in the cluster if the resources are available. Service tasks on the container instance that are in the `PENDING` state are stopped immediately.
 *
 * Service tasks on the container instance that are in the `RUNNING` state are stopped and replaced according to the service's deployment configuration parameters, `minimumHealthyPercent` and `maximumPercent`. You can change the deployment configuration of your service using UpdateService.
 * + If `minimumHealthyPercent` is below 100%, the scheduler can ignore `desiredCount` temporarily during task replacement. For example, `desiredCount` is four tasks, a minimum of 50% allows the scheduler to stop two existing tasks before starting two new tasks. If the minimum is 100%, the service scheduler can't remove existing tasks until the replacement tasks are considered healthy. Tasks for services that do not use a load balancer are considered healthy if they're in the `RUNNING` state. Tasks for services that use a load balancer are considered healthy if they're in the `RUNNING` state and are reported as healthy by the load balancer.
 * + The `maximumPercent` parameter represents an upper limit on the number of running tasks during task replacement. You can use this to define the replacement batch size. For example, if `desiredCount` is four tasks, a maximum of 200% starts four new tasks before stopping the four tasks to be drained, provided that the cluster resources required to do this are available. If the maximum is 100%, then replacement tasks can't start until the draining tasks have stopped.
 *
 * Any `PENDING` or `RUNNING` tasks that do not belong to a service aren't affected. You must wait for them to finish or stop them manually.
 *
 * A container instance has completed draining when it has no more `RUNNING` tasks. You can verify this using ListTasks.
 *
 * When a container instance has been drained, you can set a container instance to `ACTIVE` status and once it has reached that status the Amazon ECS scheduler can begin scheduling tasks on the instance again.
 */
public suspend inline fun EcsClient.updateContainerInstancesState(crossinline block: UpdateContainerInstancesStateRequest.Builder.() -> Unit): UpdateContainerInstancesStateResponse = updateContainerInstancesState(UpdateContainerInstancesStateRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a service.
 *
 * For services using the rolling update (`ECS`) you can update the desired count, deployment configuration, network configuration, load balancers, service registries, enable ECS managed tags option, propagate tags option, task placement constraints and strategies, and task definition. When you update any of these parameters, Amazon ECS starts new tasks with the new configuration.
 *
 * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task, or when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*. You can update your volume configurations and trigger a new deployment. `volumeConfigurations` is only supported for REPLICA service and not DAEMON service. If you leave `volumeConfigurations``null`, it doesn't trigger a new deployment. For more infomation on volumes, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * For services using the blue/green (`CODE_DEPLOY`) deployment controller, only the desired count, deployment configuration, health check grace period, task placement constraints and strategies, enable ECS managed tags option, and propagate tags can be updated using this API. If the network configuration, platform version, task definition, or load balancer need to be updated, create a new CodeDeploy deployment. For more information, see [CreateDeployment](https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html) in the *CodeDeploy API Reference*.
 *
 * For services using an external deployment controller, you can update only the desired count, task placement constraints and strategies, health check grace period, enable ECS managed tags option, and propagate tags option, using this API. If the launch type, load balancer, network configuration, platform version, or task definition need to be updated, create a new task set For more information, see CreateTaskSet.
 *
 * You can add to or subtract from the number of instantiations of a task definition in a service by specifying the cluster that the service is running in and a new `desiredCount` parameter.
 *
 * You can attach Amazon EBS volumes to Amazon ECS tasks by configuring the volume when starting or running a task, or when creating or updating a service. For more infomation, see [Amazon EBS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * If you have updated the container image of your application, you can create a new task definition with that image and deploy it to your service. The service scheduler uses the minimum healthy percent and maximum percent parameters (in the service's deployment configuration) to determine the deployment strategy.
 *
 * If your updated Docker image uses the same tag as what is in the existing task definition for your service (for example, `my_image:latest`), you don't need to create a new revision of your task definition. You can update the service using the `forceNewDeployment` option. The new tasks launched by the deployment pull the current image/tag combination from your repository when they start.
 *
 * You can also update the deployment configuration of a service. When a deployment is triggered by updating the task definition of a service, the service scheduler uses the deployment configuration parameters, `minimumHealthyPercent` and `maximumPercent`, to determine the deployment strategy.
 * + If `minimumHealthyPercent` is below 100%, the scheduler can ignore `desiredCount` temporarily during a deployment. For example, if `desiredCount` is four tasks, a minimum of 50% allows the scheduler to stop two existing tasks before starting two new tasks. Tasks for services that don't use a load balancer are considered healthy if they're in the `RUNNING` state. Tasks for services that use a load balancer are considered healthy if they're in the `RUNNING` state and are reported as healthy by the load balancer.
 * + The `maximumPercent` parameter represents an upper limit on the number of running tasks during a deployment. You can use it to define the deployment batch size. For example, if `desiredCount` is four tasks, a maximum of 200% starts four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available).
 *
 * When UpdateService stops a task during a deployment, the equivalent of `docker stop` is issued to the containers running in the task. This results in a `SIGTERM` and a 30-second timeout. After this, `SIGKILL` is sent and the containers are forcibly stopped. If the container handles the `SIGTERM` gracefully and exits within 30 seconds from receiving it, no `SIGKILL` is sent.
 *
 * When the service scheduler launches new tasks, it determines task placement in your cluster with the following logic.
 * + Determine which of the container instances in your cluster can support your service's task definition. For example, they have the required CPU, memory, ports, and container instance attributes.
 * + By default, the service scheduler attempts to balance tasks across Availability Zones in this manner even though you can choose a different placement strategy.
 *    + Sort the valid container instances by the fewest number of running tasks for this service in the same Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each have zero, valid container instances in either zone B or C are considered optimal for placement.
 *    + Place the new service task on a valid container instance in an optimal Availability Zone (based on the previous steps), favoring container instances with the fewest number of running tasks for this service.
 *
 * When the service scheduler stops running tasks, it attempts to maintain balance across the Availability Zones in your cluster using the following logic:
 * + Sort the container instances by the largest number of running tasks for this service in the same Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each have two, container instances in either zone B or C are considered optimal for termination.
 * + Stop the task on a container instance in an optimal Availability Zone (based on the previous steps), favoring container instances with the largest number of running tasks for this service.
 *
 * You must have a service-linked role when you update any of the following service properties:
 * + `loadBalancers`,
 * + `serviceRegistries`
 * For more information about the role see the `CreateService` request parameter `role`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html#ECS-CreateService-request-role).
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.UpdateService.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.UpdateService.sample2
 */
public suspend inline fun EcsClient.updateService(crossinline block: UpdateServiceRequest.Builder.() -> Unit): UpdateServiceResponse = updateService(UpdateServiceRequest.Builder().apply(block).build())

/**
 * Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task set in a service will transition to the service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.updateServicePrimaryTaskSet(crossinline block: UpdateServicePrimaryTaskSetRequest.Builder.() -> Unit): UpdateServicePrimaryTaskSetResponse = updateServicePrimaryTaskSet(UpdateServicePrimaryTaskSetRequest.Builder().apply(block).build())

/**
 * Updates the protection status of a task. You can set `protectionEnabled` to `true` to protect your task from termination during scale-in events from [Service Autoscaling](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html) or [deployments](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html).
 *
 * Task-protection, by default, expires after 2 hours at which point Amazon ECS clears the `protectionEnabled` property making the task eligible for termination by a subsequent scale-in event.
 *
 * You can specify a custom expiration period for task protection from 1 minute to up to 2,880 minutes (48 hours). To specify the custom expiration period, set the `expiresInMinutes` property. The `expiresInMinutes` property is always reset when you invoke this operation for a task that already has `protectionEnabled` set to `true`. You can keep extending the protection expiration period of a task by invoking this operation repeatedly.
 *
 * To learn more about Amazon ECS task protection, see [Task scale-in protection](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection.html) in the **Amazon Elastic Container Service Developer Guide**.
 *
 * This operation is only supported for tasks belonging to an Amazon ECS service. Invoking this operation for a standalone task will result in an `TASK_NOT_VALID` failure. For more information, see [API failure reasons](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html).
 *
 * If you prefer to set task protection from within the container, we recommend using the [Task scale-in protection endpoint](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-scale-in-protection-endpoint.html).
 *
 * @sample aws.sdk.kotlin.services.ecs.samples.UpdateTaskProtection.sample
 * @sample aws.sdk.kotlin.services.ecs.samples.UpdateTaskProtection.sample2
 * @sample aws.sdk.kotlin.services.ecs.samples.UpdateTaskProtection.sample3
 */
public suspend inline fun EcsClient.updateTaskProtection(crossinline block: UpdateTaskProtectionRequest.Builder.() -> Unit): UpdateTaskProtectionResponse = updateTaskProtection(UpdateTaskProtectionRequest.Builder().apply(block).build())

/**
 * Modifies a task set. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public suspend inline fun EcsClient.updateTaskSet(crossinline block: UpdateTaskSetRequest.Builder.() -> Unit): UpdateTaskSetResponse = updateTaskSet(UpdateTaskSetRequest.Builder().apply(block).build())
