// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.serde

import aws.sdk.kotlin.services.ecrpublic.model.EcrPublicException
import aws.sdk.kotlin.services.ecrpublic.model.PutRegistryCatalogDataResponse
import aws.sdk.kotlin.services.ecrpublic.model.RegistryCatalogData
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutRegistryCatalogDataOperationDeserializer: HttpDeserializer.NonStreaming<PutRegistryCatalogDataResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutRegistryCatalogDataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutRegistryCatalogDataError(context, call, payload)
        }
        val builder = PutRegistryCatalogDataResponse.Builder()

        if (payload != null) {
            deserializePutRegistryCatalogDataOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutRegistryCatalogDataError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrPublicException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedCommandException" -> UnsupportedCommandExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcrPublicException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutRegistryCatalogDataOperationBody(builder: PutRegistryCatalogDataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REGISTRYCATALOGDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("registryCatalogData"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REGISTRYCATALOGDATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REGISTRYCATALOGDATA_DESCRIPTOR.index -> builder.registryCatalogData = deserializeRegistryCatalogDataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
