// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that contains the catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.
 */
public class RepositoryCatalogDataInput private constructor(builder: Builder) {
    /**
     * A detailed description of the contents of the repository. It's publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
     */
    public val aboutText: kotlin.String? = builder.aboutText
    /**
     * The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures appear as badges on the repository and are used as search filters.
     *
     * If an unsupported tag is added to your repository catalog data, it's associated with the repository and can be retrieved using the API but isn't discoverable in the Amazon ECR Public Gallery.
     *
     * + `ARM`
     * + `ARM 64`
     * + `x86`
     * + `x86-64`
     */
    public val architectures: List<String>? = builder.architectures
    /**
     * A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The base64-encoded repository logo payload.
     *
     * The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.
     */
    public val logoImageBlob: kotlin.ByteArray? = builder.logoImageBlob
    /**
     * The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems appear as badges on the repository and are used as search filters.
     *
     * If an unsupported tag is added to your repository catalog data, it's associated with the repository and can be retrieved using the API but isn't discoverable in the Amazon ECR Public Gallery.
     *
     * + `Linux`
     * + `Windows`
     */
    public val operatingSystems: List<String>? = builder.operatingSystems
    /**
     * Detailed information about how to use the contents of the repository. It's publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
     */
    public val usageText: kotlin.String? = builder.usageText

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogDataInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryCatalogDataInput(")
        append("aboutText=$aboutText,")
        append("architectures=$architectures,")
        append("description=$description,")
        append("logoImageBlob=$logoImageBlob,")
        append("operatingSystems=$operatingSystems,")
        append("usageText=$usageText")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aboutText?.hashCode() ?: 0
        result = 31 * result + (architectures?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (logoImageBlob?.contentHashCode() ?: 0)
        result = 31 * result + (operatingSystems?.hashCode() ?: 0)
        result = 31 * result + (usageText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryCatalogDataInput

        if (aboutText != other.aboutText) return false
        if (architectures != other.architectures) return false
        if (description != other.description) return false
        if (logoImageBlob != null) {
            if (other.logoImageBlob == null) return false
            if (!logoImageBlob.contentEquals(other.logoImageBlob)) return false
        } else if (other.logoImageBlob != null) return false
        if (operatingSystems != other.operatingSystems) return false
        if (usageText != other.usageText) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogDataInput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A detailed description of the contents of the repository. It's publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
         */
        public var aboutText: kotlin.String? = null
        /**
         * The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures appear as badges on the repository and are used as search filters.
         *
         * If an unsupported tag is added to your repository catalog data, it's associated with the repository and can be retrieved using the API but isn't discoverable in the Amazon ECR Public Gallery.
         *
         * + `ARM`
         * + `ARM 64`
         * + `x86`
         * + `x86-64`
         */
        public var architectures: List<String>? = null
        /**
         * A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
         */
        public var description: kotlin.String? = null
        /**
         * The base64-encoded repository logo payload.
         *
         * The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.
         */
        public var logoImageBlob: kotlin.ByteArray? = null
        /**
         * The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems appear as badges on the repository and are used as search filters.
         *
         * If an unsupported tag is added to your repository catalog data, it's associated with the repository and can be retrieved using the API but isn't discoverable in the Amazon ECR Public Gallery.
         *
         * + `Linux`
         * + `Windows`
         */
        public var operatingSystems: List<String>? = null
        /**
         * Detailed information about how to use the contents of the repository. It's publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
         */
        public var usageText: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogDataInput) : this() {
            this.aboutText = x.aboutText
            this.architectures = x.architectures
            this.description = x.description
            this.logoImageBlob = x.logoImageBlob
            this.operatingSystems = x.operatingSystems
            this.usageText = x.usageText
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogDataInput = RepositoryCatalogDataInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
