// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that describes the image tag details that are returned by a DescribeImageTags action.
 */
public class ReferencedImageDetail private constructor(builder: Builder) {
    /**
     * The artifact media type of the image.
     */
    public val artifactMediaType: kotlin.String? = builder.artifactMediaType
    /**
     * The `sha256` digest of the image manifest.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The media type of the image manifest.
     */
    public val imageManifestMediaType: kotlin.String? = builder.imageManifestMediaType
    /**
     * The date and time, expressed in standard JavaScript date format, which the current image tag was pushed to the repository at.
     */
    public val imagePushedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.imagePushedAt
    /**
     * The size, in bytes, of the image in the repository.
     *
     * If the image is a manifest list, this is the max size of all manifests in the list.
     *
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it might return a larger image size than the image sizes that are returned by DescribeImages.
     */
    public val imageSizeInBytes: kotlin.Long? = builder.imageSizeInBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.ReferencedImageDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReferencedImageDetail(")
        append("artifactMediaType=$artifactMediaType,")
        append("imageDigest=$imageDigest,")
        append("imageManifestMediaType=$imageManifestMediaType,")
        append("imagePushedAt=$imagePushedAt,")
        append("imageSizeInBytes=$imageSizeInBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactMediaType?.hashCode() ?: 0
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (imageManifestMediaType?.hashCode() ?: 0)
        result = 31 * result + (imagePushedAt?.hashCode() ?: 0)
        result = 31 * result + (imageSizeInBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReferencedImageDetail

        if (artifactMediaType != other.artifactMediaType) return false
        if (imageDigest != other.imageDigest) return false
        if (imageManifestMediaType != other.imageManifestMediaType) return false
        if (imagePushedAt != other.imagePushedAt) return false
        if (imageSizeInBytes != other.imageSizeInBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.ReferencedImageDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The artifact media type of the image.
         */
        public var artifactMediaType: kotlin.String? = null
        /**
         * The `sha256` digest of the image manifest.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The media type of the image manifest.
         */
        public var imageManifestMediaType: kotlin.String? = null
        /**
         * The date and time, expressed in standard JavaScript date format, which the current image tag was pushed to the repository at.
         */
        public var imagePushedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size, in bytes, of the image in the repository.
         *
         * If the image is a manifest list, this is the max size of all manifests in the list.
         *
         * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it might return a larger image size than the image sizes that are returned by DescribeImages.
         */
        public var imageSizeInBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.ReferencedImageDetail) : this() {
            this.artifactMediaType = x.artifactMediaType
            this.imageDigest = x.imageDigest
            this.imageManifestMediaType = x.imageManifestMediaType
            this.imagePushedAt = x.imagePushedAt
            this.imageSizeInBytes = x.imageSizeInBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.ReferencedImageDetail = ReferencedImageDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
