// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that describes an image that's returned by a DescribeImages operation.
 */
public class ImageDetail private constructor(builder: Builder) {
    /**
     * The artifact media type of the image.
     */
    public val artifactMediaType: kotlin.String? = builder.artifactMediaType
    /**
     * The `sha256` digest of the image manifest.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The media type of the image manifest.
     */
    public val imageManifestMediaType: kotlin.String? = builder.imageManifestMediaType
    /**
     * The date and time, expressed in standard JavaScript date format, that the current image was pushed to the repository at.
     */
    public val imagePushedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.imagePushedAt
    /**
     * The size, in bytes, of the image in the repository.
     *
     * If the image is a manifest list, this is the max size of all manifests in the list.
     *
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it might return a larger image size than the image sizes that are returned by DescribeImages.
     */
    public val imageSizeInBytes: kotlin.Long? = builder.imageSizeInBytes
    /**
     * The list of tags that's associated with this image.
     */
    public val imageTags: List<String>? = builder.imageTags
    /**
     * The Amazon Web Services account ID that's associated with the public registry where this image belongs.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the repository where this image belongs.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.ImageDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageDetail(")
        append("artifactMediaType=$artifactMediaType,")
        append("imageDigest=$imageDigest,")
        append("imageManifestMediaType=$imageManifestMediaType,")
        append("imagePushedAt=$imagePushedAt,")
        append("imageSizeInBytes=$imageSizeInBytes,")
        append("imageTags=$imageTags,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactMediaType?.hashCode() ?: 0
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (imageManifestMediaType?.hashCode() ?: 0)
        result = 31 * result + (imagePushedAt?.hashCode() ?: 0)
        result = 31 * result + (imageSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (imageTags?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageDetail

        if (artifactMediaType != other.artifactMediaType) return false
        if (imageDigest != other.imageDigest) return false
        if (imageManifestMediaType != other.imageManifestMediaType) return false
        if (imagePushedAt != other.imagePushedAt) return false
        if (imageSizeInBytes != other.imageSizeInBytes) return false
        if (imageTags != other.imageTags) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.ImageDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The artifact media type of the image.
         */
        public var artifactMediaType: kotlin.String? = null
        /**
         * The `sha256` digest of the image manifest.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The media type of the image manifest.
         */
        public var imageManifestMediaType: kotlin.String? = null
        /**
         * The date and time, expressed in standard JavaScript date format, that the current image was pushed to the repository at.
         */
        public var imagePushedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The size, in bytes, of the image in the repository.
         *
         * If the image is a manifest list, this is the max size of all manifests in the list.
         *
         * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size, so it might return a larger image size than the image sizes that are returned by DescribeImages.
         */
        public var imageSizeInBytes: kotlin.Long? = null
        /**
         * The list of tags that's associated with this image.
         */
        public var imageTags: List<String>? = null
        /**
         * The Amazon Web Services account ID that's associated with the public registry where this image belongs.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the repository where this image belongs.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.ImageDetail) : this() {
            this.artifactMediaType = x.artifactMediaType
            this.imageDigest = x.imageDigest
            this.imageManifestMediaType = x.imageManifestMediaType
            this.imagePushedAt = x.imagePushedAt
            this.imageSizeInBytes = x.imageSizeInBytes
            this.imageTags = x.imageTags
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.ImageDetail = ImageDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
