// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeImageTagsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of repository results that's returned by `DescribeImageTags` in paginated output. When this parameter is used, `DescribeImageTags` only returns `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `DescribeImageTags` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter isn't used, then `DescribeImageTags` returns up to 100 results and a `nextToken` value, if applicable. If you specify images with `imageIds`, you can't use this option.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value that's returned from a previous paginated `DescribeImageTags` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. If there are no more results to return, this value is `null`. If you specify images with `imageIds`, you can't use this option.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services account ID that's associated with the public registry that contains the repository where images are described. If you do not specify a registry, the default public registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the repository that contains the image tag details to describe.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeImageTagsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeImageTagsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of repository results that's returned by `DescribeImageTags` in paginated output. When this parameter is used, `DescribeImageTags` only returns `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `DescribeImageTags` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter isn't used, then `DescribeImageTags` returns up to 100 results and a `nextToken` value, if applicable. If you specify images with `imageIds`, you can't use this option.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value that's returned from a previous paginated `DescribeImageTags` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. If there are no more results to return, this value is `null`. If you specify images with `imageIds`, you can't use this option.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that's associated with the public registry that contains the repository where images are described. If you do not specify a registry, the default public registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the repository that contains the image tag details to describe.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsRequest = DescribeImageTagsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
