// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An authorization token data object that corresponds to a public registry.
 */
public class AuthorizationData private constructor(builder: Builder) {
    /**
     * A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the string is decoded, it's presented in the format `user:password` for public registry authentication using `docker login`.
     */
    public val authorizationToken: kotlin.String? = builder.authorizationToken
    /**
     * The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are valid for 12 hours.
     */
    public val expiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.AuthorizationData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizationData(")
        append("authorizationToken=$authorizationToken,")
        append("expiresAt=$expiresAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationToken?.hashCode() ?: 0
        result = 31 * result + (expiresAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthorizationData

        if (authorizationToken != other.authorizationToken) return false
        if (expiresAt != other.expiresAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.AuthorizationData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the string is decoded, it's presented in the format `user:password` for public registry authentication using `docker login`.
         */
        public var authorizationToken: kotlin.String? = null
        /**
         * The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are valid for 12 hours.
         */
        public var expiresAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.AuthorizationData) : this() {
            this.authorizationToken = x.authorizationToken
            this.expiresAt = x.expiresAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.AuthorizationData = AuthorizationData(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
