// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.serde

import aws.sdk.kotlin.services.ecrpublic.model.CompleteLayerUploadResponse
import aws.sdk.kotlin.services.ecrpublic.model.EcrPublicException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CompleteLayerUploadOperationDeserializer: HttpDeserialize<CompleteLayerUploadResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CompleteLayerUploadResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCompleteLayerUploadError(context, call)
        }
        val builder = CompleteLayerUploadResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCompleteLayerUploadOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCompleteLayerUploadError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrPublicException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LayerAlreadyExistsException" -> LayerAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedCommandException" -> UnsupportedCommandExceptionDeserializer().deserialize(context, wrappedCall)
        "EmptyUploadException" -> EmptyUploadExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLayerException" -> InvalidLayerExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "LayerPartTooSmallException" -> LayerPartTooSmallExceptionDeserializer().deserialize(context, wrappedCall)
        "RegistryNotFoundException" -> RegistryNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UploadNotFoundException" -> UploadNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcrPublicException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCompleteLayerUploadOperationBody(builder: CompleteLayerUploadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LAYERDIGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("layerDigest"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LAYERDIGEST_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LAYERDIGEST_DESCRIPTOR.index -> builder.layerDigest = deserializeString()
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                UPLOADID_DESCRIPTOR.index -> builder.uploadId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
