// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.paginators

import aws.sdk.kotlin.services.ecrpublic.EcrPublicClient
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImagesRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImagesResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesResponse
import aws.sdk.kotlin.services.ecrpublic.model.ImageDetail
import aws.sdk.kotlin.services.ecrpublic.model.ImageTagDetail
import aws.sdk.kotlin.services.ecrpublic.model.Registry
import aws.sdk.kotlin.services.ecrpublic.model.Repository
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagesResponse]
 */
public fun EcrPublicClient.describeImagesPaginated(initialRequest: DescribeImagesRequest): Flow<DescribeImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImagesPaginated.describeImages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImagesResponse]
 */
public fun EcrPublicClient.describeImagesPaginated(block: DescribeImagesRequest.Builder.() -> Unit): Flow<DescribeImagesResponse> =
    describeImagesPaginated(DescribeImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeImagesPaginated]
 * to access the nested member [ImageDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageDetail]
 */
@JvmName("describeImagesResponseImageDetail")
public fun Flow<DescribeImagesResponse>.imageDetails(): Flow<ImageDetail> =
    transform() { response ->
        response.imageDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeImageTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeImageTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImageTagsResponse]
 */
public fun EcrPublicClient.describeImageTagsPaginated(initialRequest: DescribeImageTagsRequest): Flow<DescribeImageTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeImageTagsPaginated.describeImageTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeImageTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeImageTagsResponse]
 */
public fun EcrPublicClient.describeImageTagsPaginated(block: DescribeImageTagsRequest.Builder.() -> Unit): Flow<DescribeImageTagsResponse> =
    describeImageTagsPaginated(DescribeImageTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeImageTagsPaginated]
 * to access the nested member [ImageTagDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImageTagDetail]
 */
@JvmName("describeImageTagsResponseImageTagDetail")
public fun Flow<DescribeImageTagsResponse>.imageTagDetails(): Flow<ImageTagDetail> =
    transform() { response ->
        response.imageTagDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeRegistriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRegistriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRegistriesResponse]
 */
public fun EcrPublicClient.describeRegistriesPaginated(initialRequest: DescribeRegistriesRequest = DescribeRegistriesRequest { }): Flow<DescribeRegistriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeRegistriesPaginated.describeRegistries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRegistriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRegistriesResponse]
 */
public fun EcrPublicClient.describeRegistriesPaginated(block: DescribeRegistriesRequest.Builder.() -> Unit): Flow<DescribeRegistriesResponse> =
    describeRegistriesPaginated(DescribeRegistriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeRegistriesPaginated]
 * to access the nested member [Registry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Registry]
 */
@JvmName("describeRegistriesResponseRegistry")
public fun Flow<DescribeRegistriesResponse>.registries(): Flow<Registry> =
    transform() { response ->
        response.registries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeRepositoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRepositoriesResponse]
 */
public fun EcrPublicClient.describeRepositoriesPaginated(initialRequest: DescribeRepositoriesRequest = DescribeRepositoriesRequest { }): Flow<DescribeRepositoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeRepositoriesPaginated.describeRepositories(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeRepositoriesResponse]
 */
public fun EcrPublicClient.describeRepositoriesPaginated(block: DescribeRepositoriesRequest.Builder.() -> Unit): Flow<DescribeRepositoriesResponse> =
    describeRepositoriesPaginated(DescribeRepositoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeRepositoriesPaginated]
 * to access the nested member [Repository]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Repository]
 */
@JvmName("describeRepositoriesResponseRepository")
public fun Flow<DescribeRepositoriesResponse>.repositories(): Flow<Repository> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }
