// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model



/**
 * The catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.
 */
public class RepositoryCatalogData private constructor(builder: Builder) {
    /**
     * The longform description of the contents of the repository. This text appears in the repository details on the Amazon ECR Public Gallery.
     */
    public val aboutText: kotlin.String? = builder.aboutText
    /**
     * The architecture tags that are associated with the repository.
     *
     * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see RepositoryCatalogDataInput.
     */
    public val architectures: List<String>? = builder.architectures
    /**
     * The short description of the repository.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The URL that contains the logo that's associated with the repository.
     */
    public val logoUrl: kotlin.String? = builder.logoUrl
    /**
     * Indicates whether the repository is certified by Amazon Web Services Marketplace.
     */
    public val marketplaceCertified: kotlin.Boolean? = builder.marketplaceCertified
    /**
     * The operating system tags that are associated with the repository.
     *
     * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see RepositoryCatalogDataInput.
     */
    public val operatingSystems: List<String>? = builder.operatingSystems
    /**
     * The longform usage details of the contents of the repository. The usage text provides context for users of the repository.
     */
    public val usageText: kotlin.String? = builder.usageText

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryCatalogData(")
        append("aboutText=$aboutText,")
        append("architectures=$architectures,")
        append("description=$description,")
        append("logoUrl=$logoUrl,")
        append("marketplaceCertified=$marketplaceCertified,")
        append("operatingSystems=$operatingSystems,")
        append("usageText=$usageText")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aboutText?.hashCode() ?: 0
        result = 31 * result + (architectures?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (logoUrl?.hashCode() ?: 0)
        result = 31 * result + (marketplaceCertified?.hashCode() ?: 0)
        result = 31 * result + (operatingSystems?.hashCode() ?: 0)
        result = 31 * result + (usageText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryCatalogData

        if (aboutText != other.aboutText) return false
        if (architectures != other.architectures) return false
        if (description != other.description) return false
        if (logoUrl != other.logoUrl) return false
        if (marketplaceCertified != other.marketplaceCertified) return false
        if (operatingSystems != other.operatingSystems) return false
        if (usageText != other.usageText) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The longform description of the contents of the repository. This text appears in the repository details on the Amazon ECR Public Gallery.
         */
        public var aboutText: kotlin.String? = null
        /**
         * The architecture tags that are associated with the repository.
         *
         * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see RepositoryCatalogDataInput.
         */
        public var architectures: List<String>? = null
        /**
         * The short description of the repository.
         */
        public var description: kotlin.String? = null
        /**
         * The URL that contains the logo that's associated with the repository.
         */
        public var logoUrl: kotlin.String? = null
        /**
         * Indicates whether the repository is certified by Amazon Web Services Marketplace.
         */
        public var marketplaceCertified: kotlin.Boolean? = null
        /**
         * The operating system tags that are associated with the repository.
         *
         * Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For more information, see RepositoryCatalogDataInput.
         */
        public var operatingSystems: List<String>? = null
        /**
         * The longform usage details of the contents of the repository. The usage text provides context for users of the repository.
         */
        public var usageText: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogData) : this() {
            this.aboutText = x.aboutText
            this.architectures = x.architectures
            this.description = x.description
            this.logoUrl = x.logoUrl
            this.marketplaceCertified = x.marketplaceCertified
            this.operatingSystems = x.operatingSystems
            this.usageText = x.usageText
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.RepositoryCatalogData = RepositoryCatalogData(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
