// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model



/**
 * An object representing the aliases for a public registry. A public registry is given an alias when it's created. However, a custom alias can be set using the Amazon ECR console. For more information, see [Registries](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public class RegistryAlias private constructor(builder: Builder) {
    /**
     * Indicates whether the registry alias is the default alias for the registry. When the first public repository is created, your public registry is assigned a default registry alias.
     */
    public val defaultRegistryAlias: kotlin.Boolean = builder.defaultRegistryAlias
    /**
     * The name of the registry alias.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Indicates whether the registry alias is the primary alias for the registry. If true, the alias is the primary registry alias and is displayed in both the repository URL and the image URI used in the `docker pull` commands on the Amazon ECR Public Gallery.
     *
     * A registry alias that isn't the primary registry alias can be used in the repository URI in a `docker pull` command.
     */
    public val primaryRegistryAlias: kotlin.Boolean = builder.primaryRegistryAlias
    /**
     * The status of the registry alias.
     */
    public val status: aws.sdk.kotlin.services.ecrpublic.model.RegistryAliasStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.RegistryAlias = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegistryAlias(")
        append("defaultRegistryAlias=$defaultRegistryAlias,")
        append("name=$name,")
        append("primaryRegistryAlias=$primaryRegistryAlias,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultRegistryAlias.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (primaryRegistryAlias.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegistryAlias

        if (defaultRegistryAlias != other.defaultRegistryAlias) return false
        if (name != other.name) return false
        if (primaryRegistryAlias != other.primaryRegistryAlias) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.RegistryAlias = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the registry alias is the default alias for the registry. When the first public repository is created, your public registry is assigned a default registry alias.
         */
        public var defaultRegistryAlias: kotlin.Boolean = false
        /**
         * The name of the registry alias.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates whether the registry alias is the primary alias for the registry. If true, the alias is the primary registry alias and is displayed in both the repository URL and the image URI used in the `docker pull` commands on the Amazon ECR Public Gallery.
         *
         * A registry alias that isn't the primary registry alias can be used in the repository URI in a `docker pull` command.
         */
        public var primaryRegistryAlias: kotlin.Boolean = false
        /**
         * The status of the registry alias.
         */
        public var status: aws.sdk.kotlin.services.ecrpublic.model.RegistryAliasStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.RegistryAlias) : this() {
            this.defaultRegistryAlias = x.defaultRegistryAlias
            this.name = x.name
            this.primaryRegistryAlias = x.primaryRegistryAlias
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.RegistryAlias = RegistryAlias(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (status == null) status = RegistryAliasStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
