// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model



/**
 * The details of a public registry.
 */
public class Registry private constructor(builder: Builder) {
    /**
     * An array of objects that represents the aliases for a public registry.
     */
    public val aliases: List<RegistryAlias> = requireNotNull(builder.aliases) { "A non-null value must be provided for aliases" }
    /**
     * The Amazon Resource Name (ARN) of the public registry.
     */
    public val registryArn: kotlin.String = requireNotNull(builder.registryArn) { "A non-null value must be provided for registryArn" }
    /**
     * The Amazon Web Services account ID that's associated with the registry. If you do not specify a registry, the default public registry is assumed.
     */
    public val registryId: kotlin.String = requireNotNull(builder.registryId) { "A non-null value must be provided for registryId" }
    /**
     * The URI of a public registry. The URI contains a universal prefix and the registry alias.
     */
    public val registryUri: kotlin.String = requireNotNull(builder.registryUri) { "A non-null value must be provided for registryUri" }
    /**
     * Indicates whether the account is a verified Amazon Web Services Marketplace vendor. If an account is verified, each public repository receives a verified account badge on the Amazon ECR Public Gallery.
     */
    public val verified: kotlin.Boolean = requireNotNull(builder.verified) { "A non-null value must be provided for verified" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.Registry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Registry(")
        append("aliases=$aliases,")
        append("registryArn=$registryArn,")
        append("registryId=$registryId,")
        append("registryUri=$registryUri,")
        append("verified=$verified")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases.hashCode()
        result = 31 * result + (registryArn.hashCode())
        result = 31 * result + (registryId.hashCode())
        result = 31 * result + (registryUri.hashCode())
        result = 31 * result + (verified.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Registry

        if (aliases != other.aliases) return false
        if (registryArn != other.registryArn) return false
        if (registryId != other.registryId) return false
        if (registryUri != other.registryUri) return false
        if (verified != other.verified) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.Registry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects that represents the aliases for a public registry.
         */
        public var aliases: List<RegistryAlias>? = null
        /**
         * The Amazon Resource Name (ARN) of the public registry.
         */
        public var registryArn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that's associated with the registry. If you do not specify a registry, the default public registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The URI of a public registry. The URI contains a universal prefix and the registry alias.
         */
        public var registryUri: kotlin.String? = null
        /**
         * Indicates whether the account is a verified Amazon Web Services Marketplace vendor. If an account is verified, each public repository receives a verified account badge on the Amazon ECR Public Gallery.
         */
        public var verified: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.Registry) : this() {
            this.aliases = x.aliases
            this.registryArn = x.registryArn
            this.registryId = x.registryId
            this.registryUri = x.registryUri
            this.verified = x.verified
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.Registry = Registry(this)

        internal fun correctErrors(): Builder {
            if (aliases == null) aliases = emptyList()
            if (registryArn == null) registryArn = ""
            if (registryId == null) registryId = ""
            if (registryUri == null) registryUri = ""
            if (verified == null) verified = false
            return this
        }
    }
}
