// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model



public class DescribeRepositoriesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of repository results that's returned by `DescribeRepositories` in paginated output. When this parameter is used, `DescribeRepositories` only returns `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `DescribeRepositories` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter isn't used, then `DescribeRepositories` returns up to 100 results and a `nextToken` value, if applicable. If you specify repositories with `repositoryNames`, you can't use this option.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value that's returned from a previous paginated `DescribeRepositories` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. If there are no more results to return, this value is `null`. If you specify repositories with `repositoryNames`, you can't use this option.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services account ID that's associated with the registry that contains the repositories to be described. If you do not specify a registry, the default public registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.
     */
    public val repositoryNames: List<String>? = builder.repositoryNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRepositoriesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("registryId=$registryId,")
        append("repositoryNames=$repositoryNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRepositoriesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (registryId != other.registryId) return false
        if (repositoryNames != other.repositoryNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of repository results that's returned by `DescribeRepositories` in paginated output. When this parameter is used, `DescribeRepositories` only returns `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `DescribeRepositories` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter isn't used, then `DescribeRepositories` returns up to 100 results and a `nextToken` value, if applicable. If you specify repositories with `repositoryNames`, you can't use this option.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value that's returned from a previous paginated `DescribeRepositories` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. If there are no more results to return, this value is `null`. If you specify repositories with `repositoryNames`, you can't use this option.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that's associated with the registry that contains the repositories to be described. If you do not specify a registry, the default public registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.
         */
        public var repositoryNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.registryId = x.registryId
            this.repositoryNames = x.repositoryNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesRequest = DescribeRepositoriesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
