// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic.model



public class DescribeRegistriesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of repository results that's returned by `DescribeRegistries` in paginated output. When this parameter is used, `DescribeRegistries` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeRegistries` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter isn't used, then `DescribeRegistries` returns up to 100 results and a `nextToken` value, if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value that's returned from a previous paginated `DescribeRegistries` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. If there are no more results to return, this value is `null`.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRegistriesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRegistriesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of repository results that's returned by `DescribeRegistries` in paginated output. When this parameter is used, `DescribeRegistries` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeRegistries` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter isn't used, then `DescribeRegistries` returns up to 100 results and a `nextToken` value, if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value that's returned from a previous paginated `DescribeRegistries` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. If there are no more results to return, this value is `null`.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesRequest = DescribeRegistriesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
