// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecrpublic

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.ecrpublic.auth.DefaultEcrPublicAuthSchemeProvider
import aws.sdk.kotlin.services.ecrpublic.auth.EcrPublicAuthSchemeProvider
import aws.sdk.kotlin.services.ecrpublic.endpoints.DefaultEcrPublicEndpointProvider
import aws.sdk.kotlin.services.ecrpublic.endpoints.EcrPublicEndpointParameters
import aws.sdk.kotlin.services.ecrpublic.endpoints.EcrPublicEndpointProvider
import aws.sdk.kotlin.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest
import aws.sdk.kotlin.services.ecrpublic.model.BatchCheckLayerAvailabilityResponse
import aws.sdk.kotlin.services.ecrpublic.model.BatchDeleteImageRequest
import aws.sdk.kotlin.services.ecrpublic.model.BatchDeleteImageResponse
import aws.sdk.kotlin.services.ecrpublic.model.CompleteLayerUploadRequest
import aws.sdk.kotlin.services.ecrpublic.model.CompleteLayerUploadResponse
import aws.sdk.kotlin.services.ecrpublic.model.CreateRepositoryRequest
import aws.sdk.kotlin.services.ecrpublic.model.CreateRepositoryResponse
import aws.sdk.kotlin.services.ecrpublic.model.DeleteRepositoryPolicyRequest
import aws.sdk.kotlin.services.ecrpublic.model.DeleteRepositoryPolicyResponse
import aws.sdk.kotlin.services.ecrpublic.model.DeleteRepositoryRequest
import aws.sdk.kotlin.services.ecrpublic.model.DeleteRepositoryResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImageTagsResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImagesRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeImagesResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRegistriesResponse
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesRequest
import aws.sdk.kotlin.services.ecrpublic.model.DescribeRepositoriesResponse
import aws.sdk.kotlin.services.ecrpublic.model.GetAuthorizationTokenRequest
import aws.sdk.kotlin.services.ecrpublic.model.GetAuthorizationTokenResponse
import aws.sdk.kotlin.services.ecrpublic.model.GetRegistryCatalogDataRequest
import aws.sdk.kotlin.services.ecrpublic.model.GetRegistryCatalogDataResponse
import aws.sdk.kotlin.services.ecrpublic.model.GetRepositoryCatalogDataRequest
import aws.sdk.kotlin.services.ecrpublic.model.GetRepositoryCatalogDataResponse
import aws.sdk.kotlin.services.ecrpublic.model.GetRepositoryPolicyRequest
import aws.sdk.kotlin.services.ecrpublic.model.GetRepositoryPolicyResponse
import aws.sdk.kotlin.services.ecrpublic.model.InitiateLayerUploadRequest
import aws.sdk.kotlin.services.ecrpublic.model.InitiateLayerUploadResponse
import aws.sdk.kotlin.services.ecrpublic.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ecrpublic.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ecrpublic.model.PutImageRequest
import aws.sdk.kotlin.services.ecrpublic.model.PutImageResponse
import aws.sdk.kotlin.services.ecrpublic.model.PutRegistryCatalogDataRequest
import aws.sdk.kotlin.services.ecrpublic.model.PutRegistryCatalogDataResponse
import aws.sdk.kotlin.services.ecrpublic.model.PutRepositoryCatalogDataRequest
import aws.sdk.kotlin.services.ecrpublic.model.PutRepositoryCatalogDataResponse
import aws.sdk.kotlin.services.ecrpublic.model.SetRepositoryPolicyRequest
import aws.sdk.kotlin.services.ecrpublic.model.SetRepositoryPolicyResponse
import aws.sdk.kotlin.services.ecrpublic.model.TagResourceRequest
import aws.sdk.kotlin.services.ecrpublic.model.TagResourceResponse
import aws.sdk.kotlin.services.ecrpublic.model.UntagResourceRequest
import aws.sdk.kotlin.services.ecrpublic.model.UntagResourceResponse
import aws.sdk.kotlin.services.ecrpublic.model.UploadLayerPartRequest
import aws.sdk.kotlin.services.ecrpublic.model.UploadLayerPartResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ECR PUBLIC"
public const val SdkVersion: String = "1.0.32"
public const val ServiceApiVersion: String = "2020-10-30"

/**
 * # Amazon Elastic Container Registry Public
 * Amazon Elastic Container Registry Public (Amazon ECR Public) is a managed container image registry service. Amazon ECR provides both public and private registries to host your container images. You can use the Docker CLI or your preferred client to push, pull, and manage images. Amazon ECR provides a secure, scalable, and reliable registry for your Docker or Open Container Initiative (OCI) images. Amazon ECR supports public repositories with this API. For information about the Amazon ECR API for private repositories, see [Amazon Elastic Container Registry API Reference](https://docs.aws.amazon.com/AmazonECR/latest/APIReference/Welcome.html).
 */
public interface EcrPublicClient : SdkClient {
    /**
     * EcrPublicClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EcrPublicClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "EcrPublic",
                "ECR_PUBLIC",
                "ecr_public",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EcrPublicClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EcrPublicClient = DefaultEcrPublicClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EcrPublicEndpointProvider = builder.endpointProvider ?: DefaultEcrPublicEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EcrPublicAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEcrPublicAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ECR PUBLIC"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EcrPublicEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EcrPublicAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Checks the availability of one or more image layers that are within a repository in a public registry. When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun batchCheckLayerAvailability(input: BatchCheckLayerAvailabilityRequest): BatchCheckLayerAvailabilityResponse

    /**
     * Deletes a list of specified images that are within a repository in a public registry. Images are specified with either an `imageTag` or `imageDigest`.
     *
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag from an image, the image is deleted from your repository.
     *
     * You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.
     */
    public suspend fun batchDeleteImage(input: BatchDeleteImageRequest): BatchDeleteImageResponse

    /**
     * Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and upload ID. You can optionally provide a `sha256` digest of the image layer for data validation purposes.
     *
     * When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the upload is complete.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun completeLayerUpload(input: CompleteLayerUploadRequest): CompleteLayerUploadResponse

    /**
     * Creates a repository in a public registry. For more information, see [Amazon ECR repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse

    /**
     * Deletes a repository in a public registry. If the repository contains images, you must either manually delete all images in the repository or use the `force` option. This option deletes all images on your behalf before deleting the repository.
     */
    public suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse

    /**
     * Deletes the repository policy that's associated with the specified repository.
     */
    public suspend fun deleteRepositoryPolicy(input: DeleteRepositoryPolicyRequest): DeleteRepositoryPolicyResponse

    /**
     * Returns the image tag details for a repository in a public registry.
     */
    public suspend fun describeImageTags(input: DescribeImageTagsRequest): DescribeImageTagsResponse

    /**
     * Returns metadata that's related to the images in a repository in a public registry.
     *
     * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size. Therefore, it might return a larger image size than the image sizes that are returned by DescribeImages.
     */
    public suspend fun describeImages(input: DescribeImagesRequest): DescribeImagesResponse

    /**
     * Returns details for a public registry.
     */
    public suspend fun describeRegistries(input: DescribeRegistriesRequest = DescribeRegistriesRequest { }): DescribeRegistriesResponse

    /**
     * Describes repositories that are in a public registry.
     */
    public suspend fun describeRepositories(input: DescribeRepositoriesRequest = DescribeRepositoriesRequest { }): DescribeRepositoriesResponse

    /**
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours. This API requires the `ecr-public:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions.
     */
    public suspend fun getAuthorizationToken(input: GetAuthorizationTokenRequest = GetAuthorizationTokenRequest { }): GetAuthorizationTokenResponse

    /**
     * Retrieves catalog metadata for a public registry.
     */
    public suspend fun getRegistryCatalogData(input: GetRegistryCatalogDataRequest = GetRegistryCatalogDataRequest { }): GetRegistryCatalogDataResponse

    /**
     * Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the Amazon ECR Public Gallery.
     */
    public suspend fun getRepositoryCatalogData(input: GetRepositoryCatalogDataRequest): GetRepositoryCatalogDataResponse

    /**
     * Retrieves the repository policy for the specified repository.
     */
    public suspend fun getRepositoryPolicy(input: GetRepositoryPolicyRequest): GetRepositoryPolicyResponse

    /**
     * Notifies Amazon ECR that you intend to upload an image layer.
     *
     * When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn't already been uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun initiateLayerUpload(input: InitiateLayerUploadRequest): InitiateLayerUploadResponse

    /**
     * List the tags for an Amazon ECR Public resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates the image manifest and tags that are associated with an image.
     *
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags that are associated with the image.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun putImage(input: PutImageRequest): PutImageResponse

    /**
     * Create or update the catalog data for a public registry.
     */
    public suspend fun putRegistryCatalogData(input: PutRegistryCatalogDataRequest = PutRegistryCatalogDataRequest { }): PutRegistryCatalogDataResponse

    /**
     * Creates or updates the catalog data for a repository in a public registry.
     */
    public suspend fun putRepositoryCatalogData(input: PutRepositoryCatalogDataRequest): PutRepositoryCatalogDataResponse

    /**
     * Applies a repository policy to the specified public repository to control access permissions. For more information, see [Amazon ECR Repository Policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public suspend fun setRepositoryPolicy(input: SetRepositoryPolicyRequest): SetRepositoryPolicyResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Uploads an image layer part to Amazon ECR.
     *
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.
     *
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
     */
    public suspend fun uploadLayerPart(input: UploadLayerPartRequest): UploadLayerPartResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EcrPublicClient.withConfig(block: EcrPublicClient.Config.Builder.() -> Unit): EcrPublicClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEcrPublicClient(newConfig)
}

/**
 * Checks the availability of one or more image layers that are within a repository in a public registry. When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrPublicClient.batchCheckLayerAvailability(crossinline block: BatchCheckLayerAvailabilityRequest.Builder.() -> Unit): BatchCheckLayerAvailabilityResponse = batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest.Builder().apply(block).build())

/**
 * Deletes a list of specified images that are within a repository in a public registry. Images are specified with either an `imageTag` or `imageDigest`.
 *
 * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag from an image, the image is deleted from your repository.
 *
 * You can completely delete an image (and all of its tags) by specifying the digest of the image in your request.
 */
public suspend inline fun EcrPublicClient.batchDeleteImage(crossinline block: BatchDeleteImageRequest.Builder.() -> Unit): BatchDeleteImageResponse = batchDeleteImage(BatchDeleteImageRequest.Builder().apply(block).build())

/**
 * Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and upload ID. You can optionally provide a `sha256` digest of the image layer for data validation purposes.
 *
 * When an image is pushed, the CompleteLayerUpload API is called once for each new image layer to verify that the upload is complete.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrPublicClient.completeLayerUpload(crossinline block: CompleteLayerUploadRequest.Builder.() -> Unit): CompleteLayerUploadResponse = completeLayerUpload(CompleteLayerUploadRequest.Builder().apply(block).build())

/**
 * Creates a repository in a public registry. For more information, see [Amazon ECR repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrPublicClient.createRepository(crossinline block: CreateRepositoryRequest.Builder.() -> Unit): CreateRepositoryResponse = createRepository(CreateRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes a repository in a public registry. If the repository contains images, you must either manually delete all images in the repository or use the `force` option. This option deletes all images on your behalf before deleting the repository.
 */
public suspend inline fun EcrPublicClient.deleteRepository(crossinline block: DeleteRepositoryRequest.Builder.() -> Unit): DeleteRepositoryResponse = deleteRepository(DeleteRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes the repository policy that's associated with the specified repository.
 */
public suspend inline fun EcrPublicClient.deleteRepositoryPolicy(crossinline block: DeleteRepositoryPolicyRequest.Builder.() -> Unit): DeleteRepositoryPolicyResponse = deleteRepositoryPolicy(DeleteRepositoryPolicyRequest.Builder().apply(block).build())

/**
 * Returns the image tag details for a repository in a public registry.
 */
public suspend inline fun EcrPublicClient.describeImageTags(crossinline block: DescribeImageTagsRequest.Builder.() -> Unit): DescribeImageTagsResponse = describeImageTags(DescribeImageTagsRequest.Builder().apply(block).build())

/**
 * Returns metadata that's related to the images in a repository in a public registry.
 *
 * Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the `docker images` command shows the uncompressed image size. Therefore, it might return a larger image size than the image sizes that are returned by DescribeImages.
 */
public suspend inline fun EcrPublicClient.describeImages(crossinline block: DescribeImagesRequest.Builder.() -> Unit): DescribeImagesResponse = describeImages(DescribeImagesRequest.Builder().apply(block).build())

/**
 * Returns details for a public registry.
 */
public suspend inline fun EcrPublicClient.describeRegistries(crossinline block: DescribeRegistriesRequest.Builder.() -> Unit): DescribeRegistriesResponse = describeRegistries(DescribeRegistriesRequest.Builder().apply(block).build())

/**
 * Describes repositories that are in a public registry.
 */
public suspend inline fun EcrPublicClient.describeRepositories(crossinline block: DescribeRepositoriesRequest.Builder.() -> Unit): DescribeRepositoriesResponse = describeRepositories(DescribeRepositoriesRequest.Builder().apply(block).build())

/**
 * Retrieves an authorization token. An authorization token represents your IAM authentication credentials. You can use it to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours. This API requires the `ecr-public:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions.
 */
public suspend inline fun EcrPublicClient.getAuthorizationToken(crossinline block: GetAuthorizationTokenRequest.Builder.() -> Unit): GetAuthorizationTokenResponse = getAuthorizationToken(GetAuthorizationTokenRequest.Builder().apply(block).build())

/**
 * Retrieves catalog metadata for a public registry.
 */
public suspend inline fun EcrPublicClient.getRegistryCatalogData(crossinline block: GetRegistryCatalogDataRequest.Builder.() -> Unit): GetRegistryCatalogDataResponse = getRegistryCatalogData(GetRegistryCatalogDataRequest.Builder().apply(block).build())

/**
 * Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the Amazon ECR Public Gallery.
 */
public suspend inline fun EcrPublicClient.getRepositoryCatalogData(crossinline block: GetRepositoryCatalogDataRequest.Builder.() -> Unit): GetRepositoryCatalogDataResponse = getRepositoryCatalogData(GetRepositoryCatalogDataRequest.Builder().apply(block).build())

/**
 * Retrieves the repository policy for the specified repository.
 */
public suspend inline fun EcrPublicClient.getRepositoryPolicy(crossinline block: GetRepositoryPolicyRequest.Builder.() -> Unit): GetRepositoryPolicyResponse = getRepositoryPolicy(GetRepositoryPolicyRequest.Builder().apply(block).build())

/**
 * Notifies Amazon ECR that you intend to upload an image layer.
 *
 * When an image is pushed, the InitiateLayerUpload API is called once for each image layer that hasn't already been uploaded. Whether an image layer uploads is determined by the BatchCheckLayerAvailability API action.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrPublicClient.initiateLayerUpload(crossinline block: InitiateLayerUploadRequest.Builder.() -> Unit): InitiateLayerUploadResponse = initiateLayerUpload(InitiateLayerUploadRequest.Builder().apply(block).build())

/**
 * List the tags for an Amazon ECR Public resource.
 */
public suspend inline fun EcrPublicClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates the image manifest and tags that are associated with an image.
 *
 * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags that are associated with the image.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrPublicClient.putImage(crossinline block: PutImageRequest.Builder.() -> Unit): PutImageResponse = putImage(PutImageRequest.Builder().apply(block).build())

/**
 * Create or update the catalog data for a public registry.
 */
public suspend inline fun EcrPublicClient.putRegistryCatalogData(crossinline block: PutRegistryCatalogDataRequest.Builder.() -> Unit): PutRegistryCatalogDataResponse = putRegistryCatalogData(PutRegistryCatalogDataRequest.Builder().apply(block).build())

/**
 * Creates or updates the catalog data for a repository in a public registry.
 */
public suspend inline fun EcrPublicClient.putRepositoryCatalogData(crossinline block: PutRepositoryCatalogDataRequest.Builder.() -> Unit): PutRepositoryCatalogDataResponse = putRepositoryCatalogData(PutRepositoryCatalogDataRequest.Builder().apply(block).build())

/**
 * Applies a repository policy to the specified public repository to control access permissions. For more information, see [Amazon ECR Repository Policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html) in the *Amazon Elastic Container Registry User Guide*.
 */
public suspend inline fun EcrPublicClient.setRepositoryPolicy(crossinline block: SetRepositoryPolicyRequest.Builder.() -> Unit): SetRepositoryPolicyResponse = setRepositoryPolicy(SetRepositoryPolicyRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.
 */
public suspend inline fun EcrPublicClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
public suspend inline fun EcrPublicClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Uploads an image layer part to Amazon ECR.
 *
 * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (about 20MB). The UploadLayerPart API is called once for each new image layer part.
 *
 * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the `docker` CLI to pull, tag, and push images.
 */
public suspend inline fun EcrPublicClient.uploadLayerPart(crossinline block: UploadLayerPartRequest.Builder.() -> Unit): UploadLayerPartResponse = uploadLayerPart(UploadLayerPartRequest.Builder().apply(block).build())
