// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewStatus
import aws.sdk.kotlin.services.ecr.model.StartLifecyclePolicyPreviewResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartLifecyclePolicyPreviewOperationDeserializer: HttpDeserializer.NonStreaming<StartLifecyclePolicyPreviewResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartLifecyclePolicyPreviewResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartLifecyclePolicyPreviewError(context, call, payload)
        }
        val builder = StartLifecyclePolicyPreviewResponse.Builder()

        if (payload != null) {
            deserializeStartLifecyclePolicyPreviewOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartLifecyclePolicyPreviewError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LifecyclePolicyNotFoundException" -> LifecyclePolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LifecyclePolicyPreviewInProgressException" -> LifecyclePolicyPreviewInProgressExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartLifecyclePolicyPreviewOperationBody(builder: StartLifecyclePolicyPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLEPOLICYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lifecyclePolicyText"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLEPOLICYTEXT_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLEPOLICYTEXT_DESCRIPTOR.index -> builder.lifecyclePolicyText = deserializeString()
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LifecyclePolicyPreviewStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
