// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewResponse
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewResult
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewStatus
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLifecyclePolicyPreviewOperationDeserializer: HttpDeserializer.NonStreaming<GetLifecyclePolicyPreviewResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetLifecyclePolicyPreviewResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLifecyclePolicyPreviewError(context, call, payload)
        }
        val builder = GetLifecyclePolicyPreviewResponse.Builder()

        if (payload != null) {
            deserializeGetLifecyclePolicyPreviewOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetLifecyclePolicyPreviewError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LifecyclePolicyPreviewNotFoundException" -> LifecyclePolicyPreviewNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLifecyclePolicyPreviewOperationBody(builder: GetLifecyclePolicyPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLEPOLICYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lifecyclePolicyText"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PREVIEWRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("previewResults"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("summary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLEPOLICYTEXT_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PREVIEWRESULTS_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLEPOLICYTEXT_DESCRIPTOR.index -> builder.lifecyclePolicyText = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PREVIEWRESULTS_DESCRIPTOR.index -> builder.previewResults =
                    deserializer.deserializeList(PREVIEWRESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<LifecyclePolicyPreviewResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLifecyclePolicyPreviewResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LifecyclePolicyPreviewStatus.fromValue(it) }
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeLifecyclePolicyPreviewSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
