// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.DescribeImageReplicationStatusResponse
import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.ImageIdentifier
import aws.sdk.kotlin.services.ecr.model.ImageReplicationStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeImageReplicationStatusOperationDeserializer: HttpDeserializer.NonStreaming<DescribeImageReplicationStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeImageReplicationStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeImageReplicationStatusError(context, call, payload)
        }
        val builder = DescribeImageReplicationStatusResponse.Builder()

        if (payload != null) {
            deserializeDescribeImageReplicationStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeImageReplicationStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ImageNotFoundException" -> ImageNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImageReplicationStatusOperationBody(builder: DescribeImageReplicationStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IMAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("imageId"))
    val REPLICATIONSTATUSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("replicationStatuses"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IMAGEID_DESCRIPTOR)
        field(REPLICATIONSTATUSES_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IMAGEID_DESCRIPTOR.index -> builder.imageId = deserializeImageIdentifierDocument(deserializer)
                REPLICATIONSTATUSES_DESCRIPTOR.index -> builder.replicationStatuses =
                    deserializer.deserializeList(REPLICATIONSTATUSES_DESCRIPTOR) {
                        val col0 = mutableListOf<ImageReplicationStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImageReplicationStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
