// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.DeletePullThroughCacheRuleResponse
import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DeletePullThroughCacheRuleOperationDeserializer: HttpDeserializer.NonStreaming<DeletePullThroughCacheRuleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeletePullThroughCacheRuleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeletePullThroughCacheRuleError(context, call, payload)
        }
        val builder = DeletePullThroughCacheRuleResponse.Builder()

        if (payload != null) {
            deserializeDeletePullThroughCacheRuleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeletePullThroughCacheRuleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullThroughCacheRuleNotFoundException" -> PullThroughCacheRuleNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeletePullThroughCacheRuleOperationBody(builder: DeletePullThroughCacheRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREDENTIALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentialArn"))
    val CUSTOMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customRoleArn"))
    val ECRREPOSITORYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ecrRepositoryPrefix"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val UPSTREAMREGISTRYURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("upstreamRegistryUrl"))
    val UPSTREAMREPOSITORYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("upstreamRepositoryPrefix"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREDENTIALARN_DESCRIPTOR)
        field(CUSTOMROLEARN_DESCRIPTOR)
        field(ECRREPOSITORYPREFIX_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(UPSTREAMREGISTRYURL_DESCRIPTOR)
        field(UPSTREAMREPOSITORYPREFIX_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREDENTIALARN_DESCRIPTOR.index -> builder.credentialArn = deserializeString()
                CUSTOMROLEARN_DESCRIPTOR.index -> builder.customRoleArn = deserializeString()
                ECRREPOSITORYPREFIX_DESCRIPTOR.index -> builder.ecrRepositoryPrefix = deserializeString()
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                UPSTREAMREGISTRYURL_DESCRIPTOR.index -> builder.upstreamRegistryUrl = deserializeString()
                UPSTREAMREPOSITORYPREFIX_DESCRIPTOR.index -> builder.upstreamRepositoryPrefix = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
