// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateRepositoryCreationTemplateRequest private constructor(builder: Builder) {
    /**
     * Updates the list of enumerable strings representing the Amazon ECR repository creation scenarios that this template will apply towards. The two supported scenarios are `PULL_THROUGH_CACHE` and `REPLICATION`
     */
    public val appliedFor: List<RctAppliedFor>? = builder.appliedFor
    /**
     * The ARN of the role to be assumed by Amazon ECR. This role must be in the same account as the registry that you are configuring. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
     */
    public val customRoleArn: kotlin.String? = builder.customRoleArn
    /**
     * A description for the repository creation template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The encryption configuration to associate with the repository creation template.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate? = builder.encryptionConfiguration
    /**
     * Updates the tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     */
    public val imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = builder.imageTagMutability
    /**
     * Updates a repository with filters that define which image tags can override the default image tag mutability setting.
     */
    public val imageTagMutabilityExclusionFilters: List<ImageTagMutabilityExclusionFilter>? = builder.imageTagMutabilityExclusionFilters
    /**
     * Updates the lifecycle policy associated with the specified repository creation template.
     */
    public val lifecyclePolicy: kotlin.String? = builder.lifecyclePolicy
    /**
     * The repository namespace prefix that matches an existing repository creation template in the registry. All repositories created using this namespace prefix will have the settings defined in this template applied. For example, a prefix of `prod` would apply to all repositories beginning with `prod/`. This includes a repository named `prod/team1` as well as a repository named `prod/repository1`.
     *
     * To apply a template to all repositories in your registry that don't have an associated creation template, you can use `ROOT` as the prefix.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * Updates the repository policy created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
     */
    public val repositoryPolicy: kotlin.String? = builder.repositoryPolicy
    /**
     * The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public val resourceTags: List<Tag>? = builder.resourceTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.UpdateRepositoryCreationTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRepositoryCreationTemplateRequest(")
        append("appliedFor=$appliedFor,")
        append("customRoleArn=$customRoleArn,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("imageTagMutability=$imageTagMutability,")
        append("imageTagMutabilityExclusionFilters=$imageTagMutabilityExclusionFilters,")
        append("lifecyclePolicy=$lifecyclePolicy,")
        append("prefix=$prefix,")
        append("repositoryPolicy=$repositoryPolicy,")
        append("resourceTags=$resourceTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedFor?.hashCode() ?: 0
        result = 31 * result + (customRoleArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutability?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutabilityExclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (lifecyclePolicy?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (repositoryPolicy?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRepositoryCreationTemplateRequest

        if (appliedFor != other.appliedFor) return false
        if (customRoleArn != other.customRoleArn) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (imageTagMutability != other.imageTagMutability) return false
        if (imageTagMutabilityExclusionFilters != other.imageTagMutabilityExclusionFilters) return false
        if (lifecyclePolicy != other.lifecyclePolicy) return false
        if (prefix != other.prefix) return false
        if (repositoryPolicy != other.repositoryPolicy) return false
        if (resourceTags != other.resourceTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.UpdateRepositoryCreationTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Updates the list of enumerable strings representing the Amazon ECR repository creation scenarios that this template will apply towards. The two supported scenarios are `PULL_THROUGH_CACHE` and `REPLICATION`
         */
        public var appliedFor: List<RctAppliedFor>? = null
        /**
         * The ARN of the role to be assumed by Amazon ECR. This role must be in the same account as the registry that you are configuring. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
         */
        public var customRoleArn: kotlin.String? = null
        /**
         * A description for the repository creation template.
         */
        public var description: kotlin.String? = null
        /**
         * The encryption configuration to associate with the repository creation template.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate? = null
        /**
         * Updates the tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
         */
        public var imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = null
        /**
         * Updates a repository with filters that define which image tags can override the default image tag mutability setting.
         */
        public var imageTagMutabilityExclusionFilters: List<ImageTagMutabilityExclusionFilter>? = null
        /**
         * Updates the lifecycle policy associated with the specified repository creation template.
         */
        public var lifecyclePolicy: kotlin.String? = null
        /**
         * The repository namespace prefix that matches an existing repository creation template in the registry. All repositories created using this namespace prefix will have the settings defined in this template applied. For example, a prefix of `prod` would apply to all repositories beginning with `prod/`. This includes a repository named `prod/team1` as well as a repository named `prod/repository1`.
         *
         * To apply a template to all repositories in your registry that don't have an associated creation template, you can use `ROOT` as the prefix.
         */
        public var prefix: kotlin.String? = null
        /**
         * Updates the repository policy created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
         */
        public var repositoryPolicy: kotlin.String? = null
        /**
         * The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        public var resourceTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.UpdateRepositoryCreationTemplateRequest) : this() {
            this.appliedFor = x.appliedFor
            this.customRoleArn = x.customRoleArn
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.imageTagMutability = x.imageTagMutability
            this.imageTagMutabilityExclusionFilters = x.imageTagMutabilityExclusionFilters
            this.lifecyclePolicy = x.lifecyclePolicy
            this.prefix = x.prefix
            this.repositoryPolicy = x.repositoryPolicy
            this.resourceTags = x.resourceTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.UpdateRepositoryCreationTemplateRequest = UpdateRepositoryCreationTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
