// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of the repository creation template associated with the request.
 */
public class RepositoryCreationTemplate private constructor(builder: Builder) {
    /**
     * A list of enumerable Strings representing the repository creation scenarios that this template will apply towards. The two supported scenarios are PULL_THROUGH_CACHE and REPLICATION
     */
    public val appliedFor: List<RctAppliedFor>? = builder.appliedFor
    /**
     * The date and time, in JavaScript date format, when the repository creation template was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ARN of the role to be assumed by Amazon ECR. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
     */
    public val customRoleArn: kotlin.String? = builder.customRoleArn
    /**
     * The description associated with the repository creation template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The encryption configuration associated with the repository creation template.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate? = builder.encryptionConfiguration
    /**
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     */
    public val imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = builder.imageTagMutability
    /**
     * Defines the image tag mutability exclusion filters to apply when creating repositories from this template. These filters specify which image tags can override the repository's default image tag mutability setting.
     */
    public val imageTagMutabilityExclusionFilters: List<ImageTagMutabilityExclusionFilter>? = builder.imageTagMutabilityExclusionFilters
    /**
     * The lifecycle policy to use for repositories created using the template.
     */
    public val lifecyclePolicy: kotlin.String? = builder.lifecyclePolicy
    /**
     * The repository namespace prefix associated with the repository creation template.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The repository policy to apply to repositories created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
     */
    public val repositoryPolicy: kotlin.String? = builder.repositoryPolicy
    /**
     * The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public val resourceTags: List<Tag>? = builder.resourceTags
    /**
     * The date and time, in JavaScript date format, when the repository creation template was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.RepositoryCreationTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryCreationTemplate(")
        append("appliedFor=$appliedFor,")
        append("createdAt=$createdAt,")
        append("customRoleArn=$customRoleArn,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("imageTagMutability=$imageTagMutability,")
        append("imageTagMutabilityExclusionFilters=$imageTagMutabilityExclusionFilters,")
        append("lifecyclePolicy=$lifecyclePolicy,")
        append("prefix=$prefix,")
        append("repositoryPolicy=$repositoryPolicy,")
        append("resourceTags=$resourceTags,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedFor?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customRoleArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutability?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutabilityExclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (lifecyclePolicy?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (repositoryPolicy?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryCreationTemplate

        if (appliedFor != other.appliedFor) return false
        if (createdAt != other.createdAt) return false
        if (customRoleArn != other.customRoleArn) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (imageTagMutability != other.imageTagMutability) return false
        if (imageTagMutabilityExclusionFilters != other.imageTagMutabilityExclusionFilters) return false
        if (lifecyclePolicy != other.lifecyclePolicy) return false
        if (prefix != other.prefix) return false
        if (repositoryPolicy != other.repositoryPolicy) return false
        if (resourceTags != other.resourceTags) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.RepositoryCreationTemplate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of enumerable Strings representing the repository creation scenarios that this template will apply towards. The two supported scenarios are PULL_THROUGH_CACHE and REPLICATION
         */
        public var appliedFor: List<RctAppliedFor>? = null
        /**
         * The date and time, in JavaScript date format, when the repository creation template was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the role to be assumed by Amazon ECR. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
         */
        public var customRoleArn: kotlin.String? = null
        /**
         * The description associated with the repository creation template.
         */
        public var description: kotlin.String? = null
        /**
         * The encryption configuration associated with the repository creation template.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate? = null
        /**
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
         */
        public var imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = null
        /**
         * Defines the image tag mutability exclusion filters to apply when creating repositories from this template. These filters specify which image tags can override the repository's default image tag mutability setting.
         */
        public var imageTagMutabilityExclusionFilters: List<ImageTagMutabilityExclusionFilter>? = null
        /**
         * The lifecycle policy to use for repositories created using the template.
         */
        public var lifecyclePolicy: kotlin.String? = null
        /**
         * The repository namespace prefix associated with the repository creation template.
         */
        public var prefix: kotlin.String? = null
        /**
         * The repository policy to apply to repositories created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
         */
        public var repositoryPolicy: kotlin.String? = null
        /**
         * The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        public var resourceTags: List<Tag>? = null
        /**
         * The date and time, in JavaScript date format, when the repository creation template was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.RepositoryCreationTemplate) : this() {
            this.appliedFor = x.appliedFor
            this.createdAt = x.createdAt
            this.customRoleArn = x.customRoleArn
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.imageTagMutability = x.imageTagMutability
            this.imageTagMutabilityExclusionFilters = x.imageTagMutabilityExclusionFilters
            this.lifecyclePolicy = x.lifecyclePolicy
            this.prefix = x.prefix
            this.repositoryPolicy = x.repositoryPolicy
            this.resourceTags = x.resourceTags
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.RepositoryCreationTemplate = RepositoryCreationTemplate(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
