// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing a repository.
 */
public class Repository private constructor(builder: Builder) {
    /**
     * The date and time, in JavaScript date format, when the repository was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The image scanning configuration for a repository.
     */
    public val imageScanningConfiguration: aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration? = builder.imageScanningConfiguration
    /**
     * The tag mutability setting for the repository.
     */
    public val imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = builder.imageTagMutability
    /**
     * The image tag mutability exclusion filters associated with the repository. These filters specify which image tags can override the repository's default image tag mutability setting.
     */
    public val imageTagMutabilityExclusionFilters: List<ImageTagMutabilityExclusionFilter>? = builder.imageTagMutabilityExclusionFilters
    /**
     * The Amazon Web Services account ID associated with the registry that contains the repository.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the `arn:aws:ecr` namespace, followed by the region of the repository, Amazon Web Services account ID of the repository owner, repository namespace, and repository name. For example, `arn:aws:ecr:region:012345678910:repository-namespace/repository-name`.
     */
    public val repositoryArn: kotlin.String? = builder.repositoryArn
    /**
     * The name of the repository.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The URI for the repository. You can use this URI for container image `push` and `pull` operations.
     */
    public val repositoryUri: kotlin.String? = builder.repositoryUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.Repository = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Repository(")
        append("createdAt=$createdAt,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("imageScanningConfiguration=$imageScanningConfiguration,")
        append("imageTagMutability=$imageTagMutability,")
        append("imageTagMutabilityExclusionFilters=$imageTagMutabilityExclusionFilters,")
        append("registryId=$registryId,")
        append("repositoryArn=$repositoryArn,")
        append("repositoryName=$repositoryName,")
        append("repositoryUri=$repositoryUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageScanningConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutability?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutabilityExclusionFilters?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryArn?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (repositoryUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Repository

        if (createdAt != other.createdAt) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (imageScanningConfiguration != other.imageScanningConfiguration) return false
        if (imageTagMutability != other.imageTagMutability) return false
        if (imageTagMutabilityExclusionFilters != other.imageTagMutabilityExclusionFilters) return false
        if (registryId != other.registryId) return false
        if (repositoryArn != other.repositoryArn) return false
        if (repositoryName != other.repositoryName) return false
        if (repositoryUri != other.repositoryUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.Repository = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time, in JavaScript date format, when the repository was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration? = null
        /**
         * The image scanning configuration for a repository.
         */
        public var imageScanningConfiguration: aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration? = null
        /**
         * The tag mutability setting for the repository.
         */
        public var imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = null
        /**
         * The image tag mutability exclusion filters associated with the repository. These filters specify which image tags can override the repository's default image tag mutability setting.
         */
        public var imageTagMutabilityExclusionFilters: List<ImageTagMutabilityExclusionFilter>? = null
        /**
         * The Amazon Web Services account ID associated with the registry that contains the repository.
         */
        public var registryId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the `arn:aws:ecr` namespace, followed by the region of the repository, Amazon Web Services account ID of the repository owner, repository namespace, and repository name. For example, `arn:aws:ecr:region:012345678910:repository-namespace/repository-name`.
         */
        public var repositoryArn: kotlin.String? = null
        /**
         * The name of the repository.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The URI for the repository. You can use this URI for container image `push` and `pull` operations.
         */
        public var repositoryUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.Repository) : this() {
            this.createdAt = x.createdAt
            this.encryptionConfiguration = x.encryptionConfiguration
            this.imageScanningConfiguration = x.imageScanningConfiguration
            this.imageTagMutability = x.imageTagMutability
            this.imageTagMutabilityExclusionFilters = x.imageTagMutabilityExclusionFilters
            this.registryId = x.registryId
            this.repositoryArn = x.repositoryArn
            this.repositoryName = x.repositoryName
            this.repositoryUri = x.repositoryUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.Repository = Repository(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.ecr.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration] inside the given [block]
         */
        public fun imageScanningConfiguration(block: aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration.Builder.() -> kotlin.Unit) {
            this.imageScanningConfiguration = aws.sdk.kotlin.services.ecr.model.ImageScanningConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
