// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a pull through cache rule.
 */
public class PullThroughCacheRule private constructor(builder: Builder) {
    /**
     * The date and time the pull through cache was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ARN of the Secrets Manager secret associated with the pull through cache rule.
     */
    public val credentialArn: kotlin.String? = builder.credentialArn
    /**
     * The ARN of the IAM role associated with the pull through cache rule.
     */
    public val customRoleArn: kotlin.String? = builder.customRoleArn
    /**
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     */
    public val ecrRepositoryPrefix: kotlin.String? = builder.ecrRepositoryPrefix
    /**
     * The Amazon Web Services account ID associated with the registry the pull through cache rule is associated with.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The date and time, in JavaScript date format, when the pull through cache rule was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The name of the upstream source registry associated with the pull through cache rule.
     */
    public val upstreamRegistry: aws.sdk.kotlin.services.ecr.model.UpstreamRegistry? = builder.upstreamRegistry
    /**
     * The upstream registry URL associated with the pull through cache rule.
     */
    public val upstreamRegistryUrl: kotlin.String? = builder.upstreamRegistryUrl
    /**
     * The upstream repository prefix associated with the pull through cache rule.
     */
    public val upstreamRepositoryPrefix: kotlin.String? = builder.upstreamRepositoryPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.PullThroughCacheRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PullThroughCacheRule(")
        append("createdAt=$createdAt,")
        append("credentialArn=$credentialArn,")
        append("customRoleArn=$customRoleArn,")
        append("ecrRepositoryPrefix=$ecrRepositoryPrefix,")
        append("registryId=$registryId,")
        append("updatedAt=$updatedAt,")
        append("upstreamRegistry=$upstreamRegistry,")
        append("upstreamRegistryUrl=$upstreamRegistryUrl,")
        append("upstreamRepositoryPrefix=$upstreamRepositoryPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (credentialArn?.hashCode() ?: 0)
        result = 31 * result + (customRoleArn?.hashCode() ?: 0)
        result = 31 * result + (ecrRepositoryPrefix?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (upstreamRegistry?.hashCode() ?: 0)
        result = 31 * result + (upstreamRegistryUrl?.hashCode() ?: 0)
        result = 31 * result + (upstreamRepositoryPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PullThroughCacheRule

        if (createdAt != other.createdAt) return false
        if (credentialArn != other.credentialArn) return false
        if (customRoleArn != other.customRoleArn) return false
        if (ecrRepositoryPrefix != other.ecrRepositoryPrefix) return false
        if (registryId != other.registryId) return false
        if (updatedAt != other.updatedAt) return false
        if (upstreamRegistry != other.upstreamRegistry) return false
        if (upstreamRegistryUrl != other.upstreamRegistryUrl) return false
        if (upstreamRepositoryPrefix != other.upstreamRepositoryPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.PullThroughCacheRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the pull through cache was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the Secrets Manager secret associated with the pull through cache rule.
         */
        public var credentialArn: kotlin.String? = null
        /**
         * The ARN of the IAM role associated with the pull through cache rule.
         */
        public var customRoleArn: kotlin.String? = null
        /**
         * The Amazon ECR repository prefix associated with the pull through cache rule.
         */
        public var ecrRepositoryPrefix: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the registry the pull through cache rule is associated with.
         */
        public var registryId: kotlin.String? = null
        /**
         * The date and time, in JavaScript date format, when the pull through cache rule was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the upstream source registry associated with the pull through cache rule.
         */
        public var upstreamRegistry: aws.sdk.kotlin.services.ecr.model.UpstreamRegistry? = null
        /**
         * The upstream registry URL associated with the pull through cache rule.
         */
        public var upstreamRegistryUrl: kotlin.String? = null
        /**
         * The upstream repository prefix associated with the pull through cache rule.
         */
        public var upstreamRepositoryPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.PullThroughCacheRule) : this() {
            this.createdAt = x.createdAt
            this.credentialArn = x.credentialArn
            this.customRoleArn = x.customRoleArn
            this.ecrRepositoryPrefix = x.ecrRepositoryPrefix
            this.registryId = x.registryId
            this.updatedAt = x.updatedAt
            this.upstreamRegistry = x.upstreamRegistry
            this.upstreamRegistryUrl = x.upstreamRegistryUrl
            this.upstreamRepositoryPrefix = x.upstreamRepositoryPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.PullThroughCacheRule = PullThroughCacheRule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
