// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePullThroughCacheRuleRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that identifies the credentials to authenticate to the upstream registry.
     */
    public val credentialArn: kotlin.String? = builder.credentialArn
    /**
     * Amazon Resource Name (ARN) of the IAM role to be assumed by Amazon ECR to authenticate to the ECR upstream registry. This role must be in the same account as the registry that you are configuring.
     */
    public val customRoleArn: kotlin.String? = builder.customRoleArn
    /**
     * The repository name prefix to use when caching images from the source registry.
     *
     * There is always an assumed `/` applied to the end of the prefix. If you specify `ecr-public` as the prefix, Amazon ECR treats that as `ecr-public/`.
     */
    public val ecrRepositoryPrefix: kotlin.String? = builder.ecrRepositoryPrefix
    /**
     * The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the upstream registry.
     */
    public val upstreamRegistry: aws.sdk.kotlin.services.ecr.model.UpstreamRegistry? = builder.upstreamRegistry
    /**
     * The registry URL of the upstream public registry to use as the source for the pull through cache rule. The following is the syntax to use for each supported upstream registry.
     * + Amazon ECR (`ecr`) – `<accountId>.dkr.ecr.<region>.amazonaws.com`
     * + Amazon ECR Public (`ecr-public`) – `public.ecr.aws`
     * + Docker Hub (`docker-hub`) – `registry-1.docker.io`
     * + GitHub Container Registry (`github-container-registry`) – `ghcr.io`
     * + GitLab Container Registry (`gitlab-container-registry`) – `registry.gitlab.com`
     * + Kubernetes (`k8s`) – `registry.k8s.io`
     * + Microsoft Azure Container Registry (`azure-container-registry`) – `<custom>.azurecr.io`
     * + Quay (`quay`) – `quay.io`
     */
    public val upstreamRegistryUrl: kotlin.String? = builder.upstreamRegistryUrl
    /**
     * The repository name prefix of the upstream registry to match with the upstream repository name. When this field isn't specified, Amazon ECR will use the `ROOT`.
     */
    public val upstreamRepositoryPrefix: kotlin.String? = builder.upstreamRepositoryPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePullThroughCacheRuleRequest(")
        append("credentialArn=$credentialArn,")
        append("customRoleArn=$customRoleArn,")
        append("ecrRepositoryPrefix=$ecrRepositoryPrefix,")
        append("registryId=$registryId,")
        append("upstreamRegistry=$upstreamRegistry,")
        append("upstreamRegistryUrl=$upstreamRegistryUrl,")
        append("upstreamRepositoryPrefix=$upstreamRepositoryPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentialArn?.hashCode() ?: 0
        result = 31 * result + (customRoleArn?.hashCode() ?: 0)
        result = 31 * result + (ecrRepositoryPrefix?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (upstreamRegistry?.hashCode() ?: 0)
        result = 31 * result + (upstreamRegistryUrl?.hashCode() ?: 0)
        result = 31 * result + (upstreamRepositoryPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePullThroughCacheRuleRequest

        if (credentialArn != other.credentialArn) return false
        if (customRoleArn != other.customRoleArn) return false
        if (ecrRepositoryPrefix != other.ecrRepositoryPrefix) return false
        if (registryId != other.registryId) return false
        if (upstreamRegistry != other.upstreamRegistry) return false
        if (upstreamRegistryUrl != other.upstreamRegistryUrl) return false
        if (upstreamRepositoryPrefix != other.upstreamRepositoryPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that identifies the credentials to authenticate to the upstream registry.
         */
        public var credentialArn: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of the IAM role to be assumed by Amazon ECR to authenticate to the ECR upstream registry. This role must be in the same account as the registry that you are configuring.
         */
        public var customRoleArn: kotlin.String? = null
        /**
         * The repository name prefix to use when caching images from the source registry.
         *
         * There is always an assumed `/` applied to the end of the prefix. If you specify `ecr-public` as the prefix, Amazon ECR treats that as `ecr-public/`.
         */
        public var ecrRepositoryPrefix: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the upstream registry.
         */
        public var upstreamRegistry: aws.sdk.kotlin.services.ecr.model.UpstreamRegistry? = null
        /**
         * The registry URL of the upstream public registry to use as the source for the pull through cache rule. The following is the syntax to use for each supported upstream registry.
         * + Amazon ECR (`ecr`) – `<accountId>.dkr.ecr.<region>.amazonaws.com`
         * + Amazon ECR Public (`ecr-public`) – `public.ecr.aws`
         * + Docker Hub (`docker-hub`) – `registry-1.docker.io`
         * + GitHub Container Registry (`github-container-registry`) – `ghcr.io`
         * + GitLab Container Registry (`gitlab-container-registry`) – `registry.gitlab.com`
         * + Kubernetes (`k8s`) – `registry.k8s.io`
         * + Microsoft Azure Container Registry (`azure-container-registry`) – `<custom>.azurecr.io`
         * + Quay (`quay`) – `quay.io`
         */
        public var upstreamRegistryUrl: kotlin.String? = null
        /**
         * The repository name prefix of the upstream registry to match with the upstream repository name. When this field isn't specified, Amazon ECR will use the `ROOT`.
         */
        public var upstreamRepositoryPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleRequest) : this() {
            this.credentialArn = x.credentialArn
            this.customRoleArn = x.customRoleArn
            this.ecrRepositoryPrefix = x.ecrRepositoryPrefix
            this.registryId = x.registryId
            this.upstreamRegistry = x.upstreamRegistry
            this.upstreamRegistryUrl = x.upstreamRegistryUrl
            this.upstreamRepositoryPrefix = x.upstreamRepositoryPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleRequest = CreatePullThroughCacheRuleRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
