// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsResponse
import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.ImageIdentifier
import aws.sdk.kotlin.services.ecr.model.ImageScanFindings
import aws.sdk.kotlin.services.ecr.model.ImageScanStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeImageScanFindingsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeImageScanFindingsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeImageScanFindingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeImageScanFindingsError(context, call, payload)
        }
        val builder = DescribeImageScanFindingsResponse.Builder()

        if (payload != null) {
            deserializeDescribeImageScanFindingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeImageScanFindingsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ScanNotFoundException" -> ScanNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImageNotFoundException" -> ImageNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImageScanFindingsOperationBody(builder: DescribeImageScanFindingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IMAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("imageId"))
    val IMAGESCANFINDINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("imageScanFindings"))
    val IMAGESCANSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("imageScanStatus"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IMAGEID_DESCRIPTOR)
        field(IMAGESCANFINDINGS_DESCRIPTOR)
        field(IMAGESCANSTATUS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IMAGEID_DESCRIPTOR.index -> builder.imageId = deserializeImageIdentifierDocument(deserializer)
                IMAGESCANFINDINGS_DESCRIPTOR.index -> builder.imageScanFindings = deserializeImageScanFindingsDocument(deserializer)
                IMAGESCANSTATUS_DESCRIPTOR.index -> builder.imageScanStatus = deserializeImageScanStatusDocument(deserializer)
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
