// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The encryption configuration to associate with the repository creation template.
 */
public class EncryptionConfigurationForRepositoryCreationTemplate private constructor(builder: Builder) {
    /**
     * The encryption type to use.
     *
     * If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS key, which you already created. For more information, see [Protecting data using server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Console Developer Guide*.
     *
     * If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm. For more information, see [Protecting data using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html) in the *Amazon Simple Storage Service Console Developer Guide*.
     */
    public val encryptionType: aws.sdk.kotlin.services.ecr.model.EncryptionType = requireNotNull(builder.encryptionType) { "A non-null value must be provided for encryptionType" }
    /**
     * If you use the `KMS` encryption type, specify the KMS key to use for encryption. The full ARN of the KMS key must be specified. The key must exist in the same Region as the repository. If no key is specified, the default Amazon Web Services managed KMS key for Amazon ECR will be used.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfigurationForRepositoryCreationTemplate(")
        append("encryptionType=$encryptionType,")
        append("kmsKey=$kmsKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType.hashCode()
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfigurationForRepositoryCreationTemplate

        if (encryptionType != other.encryptionType) return false
        if (kmsKey != other.kmsKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The encryption type to use.
         *
         * If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS key, which you already created. For more information, see [Protecting data using server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Console Developer Guide*.
         *
         * If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm. For more information, see [Protecting data using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html) in the *Amazon Simple Storage Service Console Developer Guide*.
         */
        public var encryptionType: aws.sdk.kotlin.services.ecr.model.EncryptionType? = null
        /**
         * If you use the `KMS` encryption type, specify the KMS key to use for encryption. The full ARN of the KMS key must be specified. The key must exist in the same Region as the repository. If no key is specified, the default Amazon Web Services managed KMS key for Amazon ECR will be used.
         */
        public var kmsKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate) : this() {
            this.encryptionType = x.encryptionType
            this.kmsKey = x.kmsKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate = EncryptionConfigurationForRepositoryCreationTemplate(this)

        internal fun correctErrors(): Builder {
            if (encryptionType == null) encryptionType = EncryptionType.SdkUnknown("no value provided")
            return this
        }
    }
}
