// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeRepositoryCreationTemplatesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of repository results returned by `DescribeRepositoryCreationTemplatesRequest` in paginated output. When this parameter is used, `DescribeRepositoryCreationTemplatesRequest` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeRepositoryCreationTemplatesRequest` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribeRepositoryCreationTemplatesRequest` returns up to 100 results and a `nextToken` value, if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `DescribeRepositoryCreationTemplates` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The repository namespace prefixes associated with the repository creation templates to describe. If this value is not specified, all repository creation templates are returned.
     */
    public val prefixes: List<String>? = builder.prefixes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.DescribeRepositoryCreationTemplatesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRepositoryCreationTemplatesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("prefixes=$prefixes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (prefixes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRepositoryCreationTemplatesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (prefixes != other.prefixes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.DescribeRepositoryCreationTemplatesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of repository results returned by `DescribeRepositoryCreationTemplatesRequest` in paginated output. When this parameter is used, `DescribeRepositoryCreationTemplatesRequest` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeRepositoryCreationTemplatesRequest` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribeRepositoryCreationTemplatesRequest` returns up to 100 results and a `nextToken` value, if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `DescribeRepositoryCreationTemplates` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is `null` when there are no more results to return.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The repository namespace prefixes associated with the repository creation templates to describe. If this value is not specified, all repository creation templates are returned.
         */
        public var prefixes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.DescribeRepositoryCreationTemplatesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.prefixes = x.prefixes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.DescribeRepositoryCreationTemplatesRequest = DescribeRepositoryCreationTemplatesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
