// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UploadLayerPartRequest private constructor(builder: Builder) {
    /**
     * The base64-encoded layer part payload.
     */
    public val layerPartBlob: kotlin.ByteArray? = builder.layerPartBlob
    /**
     * The position of the first byte of the layer part witin the overall image layer.
     */
    public val partFirstByte: kotlin.Long? = builder.partFirstByte
    /**
     * The position of the last byte of the layer part within the overall image layer.
     */
    public val partLastByte: kotlin.Long? = builder.partLastByte
    /**
     * The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the repository to which you are uploading layer parts.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The upload ID from a previous InitiateLayerUpload operation to associate with the layer part upload.
     */
    public val uploadId: kotlin.String? = builder.uploadId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.UploadLayerPartRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UploadLayerPartRequest(")
        append("layerPartBlob=$layerPartBlob,")
        append("partFirstByte=$partFirstByte,")
        append("partLastByte=$partLastByte,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName,")
        append("uploadId=$uploadId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = layerPartBlob?.contentHashCode() ?: 0
        result = 31 * result + (partFirstByte?.hashCode() ?: 0)
        result = 31 * result + (partLastByte?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (uploadId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UploadLayerPartRequest

        if (layerPartBlob != null) {
            if (other.layerPartBlob == null) return false
            if (!layerPartBlob.contentEquals(other.layerPartBlob)) return false
        } else if (other.layerPartBlob != null) return false
        if (partFirstByte != other.partFirstByte) return false
        if (partLastByte != other.partLastByte) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false
        if (uploadId != other.uploadId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.UploadLayerPartRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The base64-encoded layer part payload.
         */
        public var layerPartBlob: kotlin.ByteArray? = null
        /**
         * The position of the first byte of the layer part witin the overall image layer.
         */
        public var partFirstByte: kotlin.Long? = null
        /**
         * The position of the last byte of the layer part within the overall image layer.
         */
        public var partLastByte: kotlin.Long? = null
        /**
         * The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the repository to which you are uploading layer parts.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The upload ID from a previous InitiateLayerUpload operation to associate with the layer part upload.
         */
        public var uploadId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.UploadLayerPartRequest) : this() {
            this.layerPartBlob = x.layerPartBlob
            this.partFirstByte = x.partFirstByte
            this.partLastByte = x.partLastByte
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
            this.uploadId = x.uploadId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.UploadLayerPartRequest = UploadLayerPartRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
