// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeImageScanFindingsRequest private constructor(builder: Builder) {
    /**
     * An object with identifying information for an image in an Amazon ECR repository.
     */
    public val imageId: aws.sdk.kotlin.services.ecr.model.ImageIdentifier? = builder.imageId
    /**
     * The maximum number of image scan results returned by `DescribeImageScanFindings` in paginated output. When this parameter is used, `DescribeImageScanFindings` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeImageScanFindings` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribeImageScanFindings` returns up to 100 results and a `nextToken` value, if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `DescribeImageScanFindings` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The repository for the image for which to describe the scan findings.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeImageScanFindingsRequest(")
        append("imageId=$imageId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeImageScanFindingsRequest

        if (imageId != other.imageId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object with identifying information for an image in an Amazon ECR repository.
         */
        public var imageId: aws.sdk.kotlin.services.ecr.model.ImageIdentifier? = null
        /**
         * The maximum number of image scan results returned by `DescribeImageScanFindings` in paginated output. When this parameter is used, `DescribeImageScanFindings` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `DescribeImageScanFindings` request with the returned `nextToken` value. This value can be between 1 and 1000. If this parameter is not used, then `DescribeImageScanFindings` returns up to 100 results and a `nextToken` value, if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `DescribeImageScanFindings` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value. This value is null when there are no more results to return.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The repository for the image for which to describe the scan findings.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest) : this() {
            this.imageId = x.imageId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest = DescribeImageScanFindingsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.ImageIdentifier] inside the given [block]
         */
        public fun imageId(block: aws.sdk.kotlin.services.ecr.model.ImageIdentifier.Builder.() -> kotlin.Unit) {
            this.imageId = aws.sdk.kotlin.services.ecr.model.ImageIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
