// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateRepositoryCreationTemplateRequest private constructor(builder: Builder) {
    /**
     * A list of enumerable strings representing the Amazon ECR repository creation scenarios that this template will apply towards. The two supported scenarios are `PULL_THROUGH_CACHE` and `REPLICATION`
     */
    public val appliedFor: List<RctAppliedFor>? = builder.appliedFor
    /**
     * The ARN of the role to be assumed by Amazon ECR. This role must be in the same account as the registry that you are configuring. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
     */
    public val customRoleArn: kotlin.String? = builder.customRoleArn
    /**
     * A description for the repository creation template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The encryption configuration to use for repositories created using the template.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate? = builder.encryptionConfiguration
    /**
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     */
    public val imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = builder.imageTagMutability
    /**
     * The lifecycle policy to use for repositories created using the template.
     */
    public val lifecyclePolicy: kotlin.String? = builder.lifecyclePolicy
    /**
     * The repository namespace prefix to associate with the template. All repositories created using this namespace prefix will have the settings defined in this template applied. For example, a prefix of `prod` would apply to all repositories beginning with `prod/`. Similarly, a prefix of `prod/team` would apply to all repositories beginning with `prod/team/`.
     *
     * To apply a template to all repositories in your registry that don't have an associated creation template, you can use `ROOT` as the prefix.
     *
     * There is always an assumed `/` applied to the end of the prefix. If you specify `ecr-public` as the prefix, Amazon ECR treats that as `ecr-public/`. When using a pull through cache rule, the repository prefix you specify during rule creation is what you should specify as your repository creation template prefix as well.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The repository policy to apply to repositories created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
     */
    public val repositoryPolicy: kotlin.String? = builder.repositoryPolicy
    /**
     * The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public val resourceTags: List<Tag>? = builder.resourceTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.CreateRepositoryCreationTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRepositoryCreationTemplateRequest(")
        append("appliedFor=$appliedFor,")
        append("customRoleArn=$customRoleArn,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("imageTagMutability=$imageTagMutability,")
        append("lifecyclePolicy=$lifecyclePolicy,")
        append("prefix=$prefix,")
        append("repositoryPolicy=$repositoryPolicy,")
        append("resourceTags=$resourceTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appliedFor?.hashCode() ?: 0
        result = 31 * result + (customRoleArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (imageTagMutability?.hashCode() ?: 0)
        result = 31 * result + (lifecyclePolicy?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (repositoryPolicy?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRepositoryCreationTemplateRequest

        if (appliedFor != other.appliedFor) return false
        if (customRoleArn != other.customRoleArn) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (imageTagMutability != other.imageTagMutability) return false
        if (lifecyclePolicy != other.lifecyclePolicy) return false
        if (prefix != other.prefix) return false
        if (repositoryPolicy != other.repositoryPolicy) return false
        if (resourceTags != other.resourceTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.CreateRepositoryCreationTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of enumerable strings representing the Amazon ECR repository creation scenarios that this template will apply towards. The two supported scenarios are `PULL_THROUGH_CACHE` and `REPLICATION`
         */
        public var appliedFor: List<RctAppliedFor>? = null
        /**
         * The ARN of the role to be assumed by Amazon ECR. This role must be in the same account as the registry that you are configuring. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
         */
        public var customRoleArn: kotlin.String? = null
        /**
         * A description for the repository creation template.
         */
        public var description: kotlin.String? = null
        /**
         * The encryption configuration to use for repositories created using the template.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate? = null
        /**
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of `MUTABLE` will be used which will allow image tags to be overwritten. If `IMMUTABLE` is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
         */
        public var imageTagMutability: aws.sdk.kotlin.services.ecr.model.ImageTagMutability? = null
        /**
         * The lifecycle policy to use for repositories created using the template.
         */
        public var lifecyclePolicy: kotlin.String? = null
        /**
         * The repository namespace prefix to associate with the template. All repositories created using this namespace prefix will have the settings defined in this template applied. For example, a prefix of `prod` would apply to all repositories beginning with `prod/`. Similarly, a prefix of `prod/team` would apply to all repositories beginning with `prod/team/`.
         *
         * To apply a template to all repositories in your registry that don't have an associated creation template, you can use `ROOT` as the prefix.
         *
         * There is always an assumed `/` applied to the end of the prefix. If you specify `ecr-public` as the prefix, Amazon ECR treats that as `ecr-public/`. When using a pull through cache rule, the repository prefix you specify during rule creation is what you should specify as your repository creation template prefix as well.
         */
        public var prefix: kotlin.String? = null
        /**
         * The repository policy to apply to repositories created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
         */
        public var repositoryPolicy: kotlin.String? = null
        /**
         * The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        public var resourceTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.CreateRepositoryCreationTemplateRequest) : this() {
            this.appliedFor = x.appliedFor
            this.customRoleArn = x.customRoleArn
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.imageTagMutability = x.imageTagMutability
            this.lifecyclePolicy = x.lifecyclePolicy
            this.prefix = x.prefix
            this.repositoryPolicy = x.repositoryPolicy
            this.resourceTags = x.resourceTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.CreateRepositoryCreationTemplateRequest = CreateRepositoryCreationTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
