// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.endpoints

import aws.sdk.kotlin.services.ecr.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEcrEndpointProvider: EcrEndpointProvider {
    public override suspend fun resolveEndpoint(params: EcrEndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null &&
                params.region != null
            ) {
                if (
                    params.useFips == true &&
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS &&
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://ecr-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS and dualstack are enabled, but this partition does not support one or both")
                }
                if (
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://ecr.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("Dualstack is enabled but this partition does not support dualstack")
                }
                if (
                    params.useFips == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS
                    ) {
                        return Endpoint(
                            Url.parse("https://ecr-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                }
                return Endpoint(
                    Url.parse("https://api.ecr.${params.region}.${partitionResult?.dnsSuffix}"),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
