// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.GetDownloadUrlForLayerResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDownloadUrlForLayerOperationDeserializer: HttpDeserialize<GetDownloadUrlForLayerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDownloadUrlForLayerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDownloadUrlForLayerError(context, call)
        }
        val builder = GetDownloadUrlForLayerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDownloadUrlForLayerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDownloadUrlForLayerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "UnableToGetUpstreamLayerException" -> UnableToGetUpstreamLayerExceptionDeserializer().deserialize(context, wrappedCall)
        "LayerInaccessibleException" -> LayerInaccessibleExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "LayersNotFoundException" -> LayersNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDownloadUrlForLayerOperationBody(builder: GetDownloadUrlForLayerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOWNLOADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("downloadUrl"))
    val LAYERDIGEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("layerDigest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOWNLOADURL_DESCRIPTOR)
        field(LAYERDIGEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOWNLOADURL_DESCRIPTOR.index -> builder.downloadUrl = deserializeString()
                LAYERDIGEST_DESCRIPTOR.index -> builder.layerDigest = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
