// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.BatchGetImageResponse
import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.Image
import aws.sdk.kotlin.services.ecr.model.ImageFailure
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetImageOperationDeserializer: HttpDeserialize<BatchGetImageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchGetImageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetImageError(context, call)
        }
        val builder = BatchGetImageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetImageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchGetImageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "UnableToGetUpstreamImageException" -> UnableToGetUpstreamImageExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetImageOperationBody(builder: BatchGetImageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failures"))
    val IMAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("images"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILURES_DESCRIPTOR)
        field(IMAGES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILURES_DESCRIPTOR.index -> builder.failures =
                    deserializer.deserializeList(FAILURES_DESCRIPTOR) {
                        val col0 = mutableListOf<ImageFailure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImageFailureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMAGES_DESCRIPTOR.index -> builder.images =
                    deserializer.deserializeList(IMAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<Image>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImageDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
