// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



/**
 * The details of a scanning rule for a private registry.
 */
public class RegistryScanningRule private constructor(builder: Builder) {
    /**
     * The repository filters associated with the scanning configuration for a private registry.
     */
    public val repositoryFilters: List<ScanningRepositoryFilter> = requireNotNull(builder.repositoryFilters) { "A non-null value must be provided for repositoryFilters" }
    /**
     * The frequency that scans are performed at for a private registry. When the `ENHANCED` scan type is specified, the supported scan frequencies are `CONTINUOUS_SCAN` and `SCAN_ON_PUSH`. When the `BASIC` scan type is specified, the `SCAN_ON_PUSH` scan frequency is supported. If scan on push is not specified, then the `MANUAL` scan frequency is set by default.
     */
    public val scanFrequency: aws.sdk.kotlin.services.ecr.model.ScanFrequency = requireNotNull(builder.scanFrequency) { "A non-null value must be provided for scanFrequency" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.RegistryScanningRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegistryScanningRule(")
        append("repositoryFilters=$repositoryFilters,")
        append("scanFrequency=$scanFrequency")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = repositoryFilters.hashCode()
        result = 31 * result + (scanFrequency.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegistryScanningRule

        if (repositoryFilters != other.repositoryFilters) return false
        if (scanFrequency != other.scanFrequency) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.RegistryScanningRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The repository filters associated with the scanning configuration for a private registry.
         */
        public var repositoryFilters: List<ScanningRepositoryFilter>? = null
        /**
         * The frequency that scans are performed at for a private registry. When the `ENHANCED` scan type is specified, the supported scan frequencies are `CONTINUOUS_SCAN` and `SCAN_ON_PUSH`. When the `BASIC` scan type is specified, the `SCAN_ON_PUSH` scan frequency is supported. If scan on push is not specified, then the `MANUAL` scan frequency is set by default.
         */
        public var scanFrequency: aws.sdk.kotlin.services.ecr.model.ScanFrequency? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.RegistryScanningRule) : this() {
            this.repositoryFilters = x.repositoryFilters
            this.scanFrequency = x.scanFrequency
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.RegistryScanningRule = RegistryScanningRule(this)

        internal fun correctErrors(): Builder {
            if (repositoryFilters == null) repositoryFilters = emptyList()
            if (scanFrequency == null) scanFrequency = ScanFrequency.SdkUnknown("no value provided")
            return this
        }
    }
}
