// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



/**
 * An array of objects representing the destination for a replication rule.
 */
public class ReplicationDestination private constructor(builder: Builder) {
    /**
     * The Region to replicate to.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * The Amazon Web Services account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
     */
    public val registryId: kotlin.String = requireNotNull(builder.registryId) { "A non-null value must be provided for registryId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.ReplicationDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationDestination(")
        append("region=$region,")
        append("registryId=$registryId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = region.hashCode()
        result = 31 * result + (registryId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationDestination

        if (region != other.region) return false
        if (registryId != other.registryId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.ReplicationDestination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Region to replicate to.
         */
        public var region: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
         */
        public var registryId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.ReplicationDestination) : this() {
            this.region = x.region
            this.registryId = x.registryId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.ReplicationDestination = ReplicationDestination(this)

        internal fun correctErrors(): Builder {
            if (region == null) region = ""
            if (registryId == null) registryId = ""
            return this
        }
    }
}
