// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



public class PutImageRequest private constructor(builder: Builder) {
    /**
     * The image digest of the image manifest corresponding to the image.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The image manifest corresponding to the image to be uploaded.
     */
    public val imageManifest: kotlin.String? = builder.imageManifest
    /**
     * The media type of the image manifest. If you push an image manifest that does not contain the `mediaType` field, you must specify the `imageManifestMediaType` in the request.
     */
    public val imageManifestMediaType: kotlin.String? = builder.imageManifestMediaType
    /**
     * The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.
     */
    public val imageTag: kotlin.String? = builder.imageTag
    /**
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the repository in which to put the image.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.PutImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutImageRequest(")
        append("imageDigest=$imageDigest,")
        append("imageManifest=$imageManifest,")
        append("imageManifestMediaType=$imageManifestMediaType,")
        append("imageTag=$imageTag,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = imageDigest?.hashCode() ?: 0
        result = 31 * result + (imageManifest?.hashCode() ?: 0)
        result = 31 * result + (imageManifestMediaType?.hashCode() ?: 0)
        result = 31 * result + (imageTag?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutImageRequest

        if (imageDigest != other.imageDigest) return false
        if (imageManifest != other.imageManifest) return false
        if (imageManifestMediaType != other.imageManifestMediaType) return false
        if (imageTag != other.imageTag) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.PutImageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The image digest of the image manifest corresponding to the image.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The image manifest corresponding to the image to be uploaded.
         */
        public var imageManifest: kotlin.String? = null
        /**
         * The media type of the image manifest. If you push an image manifest that does not contain the `mediaType` field, you must specify the `imageManifestMediaType` in the request.
         */
        public var imageManifestMediaType: kotlin.String? = null
        /**
         * The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.
         */
        public var imageTag: kotlin.String? = null
        /**
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the repository in which to put the image.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.PutImageRequest) : this() {
            this.imageDigest = x.imageDigest
            this.imageManifest = x.imageManifest
            this.imageManifestMediaType = x.imageManifestMediaType
            this.imageTag = x.imageTag
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.PutImageRequest = PutImageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
