// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.waiters

import aws.sdk.kotlin.services.ecr.EcrClient
import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsRequest
import aws.sdk.kotlin.services.ecr.model.DescribeImageScanFindingsResponse
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewRequest
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until an image scan is complete and findings can be accessed
 */
public suspend fun EcrClient.waitUntilImageScanComplete(request: DescribeImageScanFindingsRequest): Outcome<DescribeImageScanFindingsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeImageScanFindingsRequest, DescribeImageScanFindingsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val imageScanStatus = it.imageScanStatus
            val status = imageScanStatus?.status?.value
            status == "COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val imageScanStatus = it.imageScanStatus
            val status = imageScanStatus?.status?.value
            status == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImageScanFindings(request) }
}

/**
 * Wait until an image scan is complete and findings can be accessed
 */
public suspend fun EcrClient.waitUntilImageScanComplete(block: DescribeImageScanFindingsRequest.Builder.() -> Unit): Outcome<DescribeImageScanFindingsResponse> =
    waitUntilImageScanComplete(DescribeImageScanFindingsRequest.Builder().apply(block).build())

/**
 * Wait until a lifecycle policy preview request is complete and results can be accessed
 */
public suspend fun EcrClient.waitUntilLifecyclePolicyPreviewComplete(request: GetLifecyclePolicyPreviewRequest): Outcome<GetLifecyclePolicyPreviewResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetLifecyclePolicyPreviewRequest, GetLifecyclePolicyPreviewResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getLifecyclePolicyPreview(request) }
}

/**
 * Wait until a lifecycle policy preview request is complete and results can be accessed
 */
public suspend fun EcrClient.waitUntilLifecyclePolicyPreviewComplete(block: GetLifecyclePolicyPreviewRequest.Builder.() -> Unit): Outcome<GetLifecyclePolicyPreviewResponse> =
    waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest.Builder().apply(block).build())
