// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.UploadLayerPartResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UploadLayerPartOperationDeserializer: HttpDeserialize<UploadLayerPartResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UploadLayerPartResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUploadLayerPartError(context, call)
        }
        val builder = UploadLayerPartResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUploadLayerPartOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUploadLayerPartError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "UploadNotFoundException" -> UploadNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "KmsException" -> KmsExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLayerPartException" -> InvalidLayerPartExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUploadLayerPartOperationBody(builder: UploadLayerPartResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTBYTERECEIVED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("lastByteReceived"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTBYTERECEIVED_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTBYTERECEIVED_DESCRIPTOR.index -> builder.lastByteReceived = deserializeLong()
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                UPLOADID_DESCRIPTOR.index -> builder.uploadId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
