// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.serde

import aws.sdk.kotlin.services.ecr.model.CreatePullThroughCacheRuleResponse
import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.UpstreamRegistry
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreatePullThroughCacheRuleOperationDeserializer: HttpDeserialize<CreatePullThroughCacheRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreatePullThroughCacheRuleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreatePullThroughCacheRuleError(context, call)
        }
        val builder = CreatePullThroughCacheRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePullThroughCacheRuleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreatePullThroughCacheRuleError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PullThroughCacheRuleAlreadyExistsException" -> PullThroughCacheRuleAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedUpstreamRegistryException" -> UnsupportedUpstreamRegistryExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "SecretNotFoundException" -> SecretNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnableToAccessSecretException" -> UnableToAccessSecretExceptionDeserializer().deserialize(context, wrappedCall)
        "UnableToDecryptSecretValueException" -> UnableToDecryptSecretValueExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePullThroughCacheRuleOperationBody(builder: CreatePullThroughCacheRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREDENTIALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentialArn"))
    val ECRREPOSITORYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ecrRepositoryPrefix"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val UPSTREAMREGISTRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("upstreamRegistry"))
    val UPSTREAMREGISTRYURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("upstreamRegistryUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREDENTIALARN_DESCRIPTOR)
        field(ECRREPOSITORYPREFIX_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(UPSTREAMREGISTRY_DESCRIPTOR)
        field(UPSTREAMREGISTRYURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREDENTIALARN_DESCRIPTOR.index -> builder.credentialArn = deserializeString()
                ECRREPOSITORYPREFIX_DESCRIPTOR.index -> builder.ecrRepositoryPrefix = deserializeString()
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                UPSTREAMREGISTRY_DESCRIPTOR.index -> builder.upstreamRegistry = deserializeString().let { UpstreamRegistry.fromValue(it) }
                UPSTREAMREGISTRYURL_DESCRIPTOR.index -> builder.upstreamRegistryUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
