// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.model



public class ValidatePullThroughCacheRuleResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull through cache rule.
     */
    public val credentialArn: kotlin.String? = builder.credentialArn
    /**
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     */
    public val ecrRepositoryPrefix: kotlin.String? = builder.ecrRepositoryPrefix
    /**
     * The reason the validation failed. For more details about possible causes and how to address them, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html) in the *Amazon Elastic Container Registry User Guide*.
     */
    public val failure: kotlin.String? = builder.failure
    /**
     * Whether or not the pull through cache rule was validated. If `true`, Amazon ECR was able to reach the upstream registry and authentication was successful. If `false`, there was an issue and validation failed. The `failure` reason indicates the cause.
     */
    public val isValid: kotlin.Boolean = builder.isValid
    /**
     * The registry ID associated with the request.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The upstream registry URL associated with the pull through cache rule.
     */
    public val upstreamRegistryUrl: kotlin.String? = builder.upstreamRegistryUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecr.model.ValidatePullThroughCacheRuleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidatePullThroughCacheRuleResponse(")
        append("credentialArn=$credentialArn,")
        append("ecrRepositoryPrefix=$ecrRepositoryPrefix,")
        append("failure=$failure,")
        append("isValid=$isValid,")
        append("registryId=$registryId,")
        append("upstreamRegistryUrl=$upstreamRegistryUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentialArn?.hashCode() ?: 0
        result = 31 * result + (ecrRepositoryPrefix?.hashCode() ?: 0)
        result = 31 * result + (failure?.hashCode() ?: 0)
        result = 31 * result + (isValid.hashCode())
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (upstreamRegistryUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidatePullThroughCacheRuleResponse

        if (credentialArn != other.credentialArn) return false
        if (ecrRepositoryPrefix != other.ecrRepositoryPrefix) return false
        if (failure != other.failure) return false
        if (isValid != other.isValid) return false
        if (registryId != other.registryId) return false
        if (upstreamRegistryUrl != other.upstreamRegistryUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecr.model.ValidatePullThroughCacheRuleResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull through cache rule.
         */
        public var credentialArn: kotlin.String? = null
        /**
         * The Amazon ECR repository prefix associated with the pull through cache rule.
         */
        public var ecrRepositoryPrefix: kotlin.String? = null
        /**
         * The reason the validation failed. For more details about possible causes and how to address them, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html) in the *Amazon Elastic Container Registry User Guide*.
         */
        public var failure: kotlin.String? = null
        /**
         * Whether or not the pull through cache rule was validated. If `true`, Amazon ECR was able to reach the upstream registry and authentication was successful. If `false`, there was an issue and validation failed. The `failure` reason indicates the cause.
         */
        public var isValid: kotlin.Boolean = false
        /**
         * The registry ID associated with the request.
         */
        public var registryId: kotlin.String? = null
        /**
         * The upstream registry URL associated with the pull through cache rule.
         */
        public var upstreamRegistryUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecr.model.ValidatePullThroughCacheRuleResponse) : this() {
            this.credentialArn = x.credentialArn
            this.ecrRepositoryPrefix = x.ecrRepositoryPrefix
            this.failure = x.failure
            this.isValid = x.isValid
            this.registryId = x.registryId
            this.upstreamRegistryUrl = x.upstreamRegistryUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecr.model.ValidatePullThroughCacheRuleResponse = ValidatePullThroughCacheRuleResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
