// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecr.transform

import aws.sdk.kotlin.services.ecr.model.EcrException
import aws.sdk.kotlin.services.ecr.model.GetLifecyclePolicyPreviewResponse
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewResult
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewStatus
import aws.sdk.kotlin.services.ecr.model.LifecyclePolicyPreviewSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLifecyclePolicyPreviewOperationDeserializer: HttpDeserialize<GetLifecyclePolicyPreviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLifecyclePolicyPreviewResponse {
        if (!response.status.isSuccess()) {
            throwGetLifecyclePolicyPreviewError(context, response)
        }
        val builder = GetLifecyclePolicyPreviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLifecyclePolicyPreviewOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLifecyclePolicyPreviewError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EcrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "LifecyclePolicyPreviewNotFoundException" -> LifecyclePolicyPreviewNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RepositoryNotFoundException" -> RepositoryNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EcrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLifecyclePolicyPreviewOperationBody(builder: GetLifecyclePolicyPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLEPOLICYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lifecyclePolicyText"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PREVIEWRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("previewResults"))
    val REGISTRYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registryId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("summary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLEPOLICYTEXT_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PREVIEWRESULTS_DESCRIPTOR)
        field(REGISTRYID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLEPOLICYTEXT_DESCRIPTOR.index -> builder.lifecyclePolicyText = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PREVIEWRESULTS_DESCRIPTOR.index -> builder.previewResults =
                    deserializer.deserializeList(PREVIEWRESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<LifecyclePolicyPreviewResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLifecyclePolicyPreviewResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REGISTRYID_DESCRIPTOR.index -> builder.registryId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LifecyclePolicyPreviewStatus.fromValue(it) }
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeLifecyclePolicyPreviewSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
